/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtClassBody;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001fR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/psi/KtClass;", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lksp/com/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "classInterfaceTokenSet", "Lksp/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "accept", "R", "D", "visitor", "Lksp/org/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getClassKeyword", "Lksp/com/intellij/psi/PsiElement;", "getClassOrInterfaceKeyword", "getCompanionObjects", "", "Lksp/org/jetbrains/kotlin/psi/KtObjectDeclaration;", "getFunKeyword", "getProperties", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "isEnum", "", "isInline", "isInner", "isInterface", "isSealed", "isValue", "psi"})
public class KtClass
extends KtClassOrObject {
    @NotNull
    private final TokenSet classInterfaceTokenSet;

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue(ktClassElementType, "CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitClass(this, data2);
    }

    private final KotlinClassStub get_stub() {
        Object t = this.getStub();
        return t instanceof KotlinClassStub ? (KotlinClassStub)t : null;
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        List<KtProperty> list2 = ktClassBody != null ? ktClassBody.getProperties() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public final boolean isInline() {
        return this.hasModifier(KtTokens.INLINE_KEYWORD);
    }

    public final boolean isValue() {
        return this.hasModifier(KtTokens.VALUE_KEYWORD);
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        List<KtObjectDeclaration> list2 = ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(this.classInterfaceTokenSet);
    }

    @Nullable
    public final PsiElement getClassKeyword() {
        return this.findChildByType(KtTokens.CLASS_KEYWORD);
    }

    @Nullable
    public final PsiElement getFunKeyword() {
        KtModifierList ktModifierList = this.getModifierList();
        return ktModifierList != null ? ktModifierList.getModifier(KtTokens.FUN_KEYWORD) : null;
    }
}

