/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNode;
import ksp.org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\f\u001a\u00020\r\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\"\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"name", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsName;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "getName", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "setInlineCallMetadata", "", "expression", "psiElement", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "nameRef", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsNameRef;", "aliasedName", "js.translator"})
@JvmName(name="InlineUtils")
public final class InlineUtils {
    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = false;
            String $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = "Expected descriptor of callable, that should be inlined, but got: " + descriptor2;
            throw new AssertionError((Object)$i$a$-assert-InlineUtils$setInlineCallMetadata$22);
        }
        JsName[] $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = new JsName[2];
        $i$a$-assert-InlineUtils$setInlineCallMetadata$22[0] = InlineUtils.aliasedName(context2, descriptor2);
        Intrinsics.checkNotNullExpressionValue(context2.getInnerNameForDescriptor(descriptor2), "getInnerNameForDescriptor(...)");
        Set<JsName> candidateNames = SetsKt.setOf($i$a$-assert-InlineUtils$setInlineCallMetadata$22);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(candidateNames, descriptor2, psiElement){
            final /* synthetic */ Set<JsName> $candidateNames;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ KtElement $psiElement;
            {
                this.$candidateNames = $candidateNames;
                this.$descriptor = $descriptor;
                this.$psiElement = $psiElement;
            }

            public void visitInvocation(JsInvocation invocation) {
                Object object;
                Intrinsics.checkNotNullParameter(invocation, "invocation");
                super.visitInvocation(invocation);
                if (CollectionsKt.contains((Iterable)this.$candidateNames, InlineUtils.getName(invocation)) || Intrinsics.areEqual((object = InlineUtils.getName(invocation)) != null && (object = MetadataProperties.getDescriptor((JsName)object)) != null ? object.getOriginal() : null, this.$descriptor.getOriginal())) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInline(invocation, (Boolean)true);
                    MetadataProperties.setPsiElement(invocation, (PsiElement)this.$psiElement);
                }
            }
        };
        visitor2.accept((JsNode)expression2);
        context2.addInlineCall(descriptor2);
    }

    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(context2, "context");
        CallableDescriptor callableDescriptor = PsiUtils.getFunctionDescriptor(resolvedCall2);
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getFunctionDescriptor(...)");
        InlineUtils.setInlineCallMetadata(expression2, psiElement, callableDescriptor, context2);
    }

    public static final void setInlineCallMetadata(@NotNull JsNameRef nameRef, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (MetadataProperties.isInline(nameRef) != null) {
            return;
        }
        MetadataProperties.setDescriptor(nameRef, descriptor2);
        MetadataProperties.setInline(nameRef, (Boolean)true);
        MetadataProperties.setPsiElement(nameRef, (PsiElement)psiElement);
        context2.addInlineCall(descriptor2);
    }

    @NotNull
    public static final JsName aliasedName(@NotNull TranslationContext $this$aliasedName, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter($this$aliasedName, "<this>");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        JsExpression alias = $this$aliasedName.getAliasForDescriptor(descriptor2);
        JsNameRef jsNameRef = alias instanceof JsNameRef ? (JsNameRef)alias : null;
        JsName aliasName = jsNameRef != null ? jsNameRef.getName() : null;
        JsName jsName = aliasName;
        if (jsName == null) {
            JsName jsName2 = $this$aliasedName.getNameForDescriptor(descriptor2);
            jsName = jsName2;
            Intrinsics.checkNotNullExpressionValue(jsName2, "getNameForDescriptor(...)");
        }
        return jsName;
    }

    @Nullable
    public static final JsName getName(@Nullable JsExpression $this$name) {
        JsName jsName;
        JsExpression jsExpression = $this$name;
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)$this$name).getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression2, "getQualifier(...)");
            JsExpression qualifier2 = jsExpression2;
            jsName = InvocationUtilsKt.isCallInvocation((JsInvocation)$this$name) ? InlineUtils.getName(((JsNameRef)qualifier2).getQualifier()) : InlineUtils.getName(qualifier2);
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$this$name).getName() : null;
        }
        return jsName;
    }
}

