/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.reference;

import java.util.LinkedHashMap;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ArrayAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.DefaultAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import ksp.org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtQualifiedExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.annotations.NotNull;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression2, @NotNull TranslationContext context2) {
        if (referenceExpression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(1);
        }
        return AccessTranslationUtils.getAccessTranslator(referenceExpression2, context2, false);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression2, @NotNull TranslationContext context2, boolean forceOrderOfEvaluation) {
        if (referenceExpression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(3);
        }
        referenceExpression2 = KtPsiUtil.deparenthesize(referenceExpression2);
        assert (referenceExpression2 != null);
        if (referenceExpression2 instanceof KtQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((KtQualifiedExpression)referenceExpression2, context2, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$0(4);
            }
            return accessTranslator;
        }
        if (referenceExpression2 instanceof KtSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((KtSimpleNameExpression)referenceExpression2, context2);
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$0(5);
            }
            return accessTranslator;
        }
        if (referenceExpression2 instanceof KtArrayAccessExpression) {
            return AccessTranslationUtils.getArrayAccessTranslator((KtArrayAccessExpression)referenceExpression2, context2, forceOrderOfEvaluation);
        }
        return new DefaultAccessTranslator(referenceExpression2, context2);
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context2, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(7);
        }
        if (forceOrderOfEvaluation) {
            LinkedHashMap<KtExpression, JsExpression> indexesMap = new LinkedHashMap<KtExpression, JsExpression>();
            for (KtExpression indexExpression : expression2.getIndexExpressions()) {
                JsExpression jsIndexExpression = context2.cacheExpressionIfNeeded(Translation.translateAsExpression(indexExpression, context2));
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context2.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context2;
        }
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance(expression2, accessArrayContext);
        if (arrayAccessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$0(8);
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull KtExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(10);
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression2, context2).translateAsGet();
        if (jsExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$0(11);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayAccessTranslator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArrayAccessTranslator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

