/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.operation;

import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBlock;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import ksp.org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.lexer.KtSingleValueToken;
import ksp.org.jetbrains.kotlin.lexer.KtToken;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.annotations.NotNull;

public final class IntrinsicAssignmentTranslator
extends AssignmentTranslator {
    private final JsExpression right;
    private final AccessTranslator accessTranslator;
    private final boolean rightExpressionTrivial;
    private final JsBlock rightBlock;

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(1);
        }
        return new IntrinsicAssignmentTranslator(expression2, context2).translate();
    }

    private IntrinsicAssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(3);
        }
        super(expression2, context2);
        this.rightBlock = new JsBlock();
        this.right = this.translateRightExpression(context2, expression2);
        this.rightExpressionTrivial = this.rightBlock.isEmpty();
        KtExpression left = expression2.getLeft();
        assert (left != null);
        this.accessTranslator = this.createAccessTranslator(left, !this.rightExpressionTrivial);
    }

    private JsExpression translateRightExpression(TranslationContext context2, KtBinaryExpression expression2) {
        JsExpression result2 = TranslationUtils.translateRightExpression(context2, expression2, this.rightBlock);
        KotlinType leftType = context2.bindingContext().getType(expression2.getLeft());
        KotlinType rightType = context2.bindingContext().getType(expression2.getRight());
        if (rightType != null && KotlinBuiltIns.isCharOrNullableChar(rightType)) {
            if (leftType != null && KotlinBuiltIns.isStringOrNullableString(leftType)) {
                result2 = JsAstUtils.charToString(result2);
            } else if (leftType != null && !KotlinBuiltIns.isCharOrNullableChar(leftType)) {
                result2 = TranslationUtils.charToBoxedChar(context2, result2);
            }
        }
        return result2;
    }

    @NotNull
    private JsExpression translate() {
        if (PsiUtils.isAssignment(PsiUtils.getOperationToken(this.expression))) {
            return this.translateAsPlainAssignment();
        }
        return this.translateAsAssignmentOperation();
    }

    @NotNull
    private JsExpression translateAsAssignmentOperation() {
        if (TranslationUtils.isSimpleNameExpressionNotDelegatedLocalVar(this.expression.getLeft(), this.context()) && this.rightExpressionTrivial) {
            return this.translateAsPlainAssignmentOperation();
        }
        return this.translateAsAssignToCounterpart();
    }

    @NotNull
    private JsExpression translateAsAssignToCounterpart() {
        JsBinaryOperator operator = this.getCounterpartOperator();
        JsExpression oldValue = this.accessTranslator.translateAsGet();
        if (!this.rightExpressionTrivial) {
            oldValue = this.context().defineTemporary(oldValue);
        }
        JsBinaryOperation counterpartOperation = new JsBinaryOperation(operator, oldValue, this.right);
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(counterpartOperation);
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    @NotNull
    private JsBinaryOperator getCounterpartOperator() {
        KtToken assignmentOperationToken = PsiUtils.getOperationToken(this.expression);
        assert (assignmentOperationToken instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(assignmentOperationToken));
        KtToken counterpartToken = (KtToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(assignmentOperationToken);
        assert (OperatorTable.hasCorrespondingBinaryOperator(counterpartToken)) : "Unsupported token encountered: " + counterpartToken.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(counterpartToken);
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(5);
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignmentOperation() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsBinaryOperator operator = this.getAssignmentOperator();
        return new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
    }

    @NotNull
    private JsBinaryOperator getAssignmentOperator() {
        KtToken token = PsiUtils.getOperationToken(this.expression);
        assert (token instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(token));
        assert (OperatorTable.hasCorrespondingBinaryOperator(token)) : "Unsupported token encountered: " + token.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(6);
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignment() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(this.right);
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsAssignToCounterpart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounterpartOperator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentOperator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsPlainAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

