/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.org.jetbrains.kotlin.builtins.PrimitiveType;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import ksp.org.jetbrains.kotlin.js.config.JsConfig;
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion;
import ksp.org.jetbrains.kotlin.js.naming.SuggestedName;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import ksp.org.jetbrains.kotlin.name.FqNameUnsafe;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String EQUALS_METHOD_NAME = "equals";
    public static final String COMPARE_TO_METHOD_NAME = "compareTo_11rb$";
    public static final String LONG_FROM_NUMBER = "fromNumber";
    public static final String LONG_TO_NUMBER = "toNumber";
    public static final String LONG_FROM_INT = "fromInt";
    public static final String UINT_FROM_INT = "toUInt";
    public static final String LONG_ZERO = "ZERO";
    public static final String LONG_ONE = "ONE";
    public static final String LONG_NEG_ONE = "NEG_ONE";
    public static final String LONG_MAX_VALUE = "MAX_VALUE";
    public static final String LONG_MIN_VALUE = "MIN_VALUE";
    public static final String PRIMITIVE_COMPARE_TO = "primitiveCompareTo";
    public static final String IS_CHAR = "isChar";
    public static final String IS_NUMBER = "isNumber";
    private static final String IS_CHAR_SEQUENCE = "isCharSequence";
    public static final String GET_KCLASS = "getKClass";
    public static final String GET_KCLASS_FROM_EXPRESSION = "getKClassFromExpression";
    public static final String CREATE_KTYPE = "createKType";
    public static final String CREATE_DYNAMIC_KTYPE = "createDynamicKType";
    public static final String MARK_KTYPE_NULLABLE = "markKTypeNullable";
    public static final String CREATE_KTYPE_PARAMETER = "createKTypeParameter";
    public static final String CREATE_REIFIED_KTYPE_PARAMETER = "getReifiedTypeParameterKType";
    public static final String GET_START_KTYPE_PROJECTION = "getStarKTypeProjection";
    public static final String CREATE_COVARIANT_KTYPE_PROJECTION = "createCovariantKTypeProjection";
    public static final String CREATE_INVARIANT_KTYPE_PROJECTION = "createInvariantKTypeProjection";
    public static final String CREATE_CONTRAVARIANT_KTYPE_PROJECTION = "createContravariantKTypeProjection";
    public static final String CALLEE_NAME = "$fun";
    public static final String CALL_FUNCTION = "call";
    private static final String APPLY_FUNCTION = "apply";
    public static final String OUTER_FIELD_NAME = "$outer";
    private static final String DELEGATE = "$delegate";
    private static final String ROOT_PACKAGE = "_";
    private static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String ANOTHER_THIS_PARAMETER_NAME = "$this";
    public static final String THROW_CLASS_CAST_EXCEPTION_FUN_NAME = "throwCCE";
    public static final String THROW_ILLEGAL_ARGUMENT_EXCEPTION_FUN_NAME = "throwIAE";
    public static final String THROW_UNINITIALIZED_PROPERTY_ACCESS_EXCEPTION = "throwUPAE";
    public static final String NULL_CHECK_INTRINSIC_NAME = "ensureNotNull";
    private static final String PROTOTYPE_NAME = "prototype";
    private static final String CAPTURED_VAR_FIELD = "v";
    public static final JsNameRef IS_ARRAY_FUN_REF = new JsNameRef("isArray", "Array");
    public static final String DEFINE_INLINE_FUNCTION = "defineInlineFunction";
    public static final String DEFAULT_PARAMETER_IMPLEMENTOR_SUFFIX = "$default";
    private static final JsNameRef JS_OBJECT = new JsNameRef("Object");
    private static final JsNameRef JS_OBJECT_CREATE_FUNCTION = new JsNameRef("create", (JsExpression)JS_OBJECT);
    public static final String LOCAL_MODULE_PREFIX = "$module$";
    public static final String METADATA = "$metadata$";
    public static final String METADATA_SUPERTYPES = "interfaces";
    public static final String METADATA_SIMPLE_NAME = "simpleName";
    public static final String METADATA_CLASS_KIND = "kind";
    public static final String CLASS_KIND_ENUM = "Kind";
    public static final String CLASS_KIND_CLASS = "CLASS";
    public static final String CLASS_KIND_INTERFACE = "INTERFACE";
    public static final String CLASS_KIND_OBJECT = "OBJECT";
    public static final String OBJECT_INSTANCE_VAR_SUFFIX = "_instance";
    public static final String OBJECT_INSTANCE_FUNCTION_SUFFIX = "_getInstance";
    public static final String ENUM_NAME_FIELD = "name$";
    public static final String ENUM_ORDINAL_FIELD = "ordinal$";
    public static final String IMPORTS_FOR_INLINE_PROPERTY = "$$importsForInline$$";
    public static final String SAM_FIELD_NAME = "function$";
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    public static final String FUNCTION_CALLABLE_REF = "getCallableRef";
    @NotNull
    public static final String PROPERTY_CALLABLE_REF = "getPropertyCallableRef";
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;

    @NotNull
    public static String getFunctionTag(@NotNull CallableDescriptor functionDescriptor, @NotNull JsConfig config, @NotNull BindingContext bindingContext) {
        String intrinsicTag;
        if (functionDescriptor == null) {
            Namer.$$$reportNull$$$0(0);
        }
        if (config == null) {
            Namer.$$$reportNull$$$0(1);
        }
        if (bindingContext == null) {
            Namer.$$$reportNull$$$0(2);
        }
        if ((intrinsicTag = ArrayFIF.INSTANCE.getTag(functionDescriptor, config)) != null) {
            String string2 = intrinsicTag;
            if (string2 == null) {
                Namer.$$$reportNull$$$0(3);
            }
            return string2;
        }
        functionDescriptor = (CallableDescriptor)JsDescriptorUtils.findRealInlineDeclaration(functionDescriptor);
        String moduleName = JsDescriptorUtils.getModuleName(functionDescriptor);
        FqNameUnsafe fqNameParent = DescriptorUtils.getFqName(functionDescriptor).parent();
        String qualifier2 = null;
        if (!fqNameParent.isRoot()) {
            qualifier2 = fqNameParent.asString();
        }
        SuggestedName suggestedName = new NameSuggestion().suggest(functionDescriptor, bindingContext);
        assert (suggestedName != null) : "Suggested name can be null only for module descriptors: " + functionDescriptor;
        String mangledName = suggestedName.getNames().get(0);
        String string3 = StringUtil.join(Arrays.asList(moduleName, qualifier2, mangledName), ".");
        if (string3 == null) {
            Namer.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @NotNull
    public static String getReceiverParameterName() {
        return RECEIVER_PARAMETER_NAME;
    }

    @NotNull
    public static String getRootPackageName() {
        return ROOT_PACKAGE;
    }

    @NotNull
    public static String getPrototypeName() {
        return PROTOTYPE_NAME;
    }

    @NotNull
    public static String getDelegatePrefix() {
        return DELEGATE;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            Namer.$$$reportNull$$$0(5);
        }
        JsNameRef result2 = JsAstUtils.pureFqn(CALL_FUNCTION, functionExpression);
        MetadataProperties.setJsCall(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(6);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            Namer.$$$reportNull$$$0(7);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(APPLY_FUNCTION, functionExpression);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(8);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation createObjectWithPrototypeFrom(@NotNull JsExpression referenceToClass) {
        if (referenceToClass == null) {
            Namer.$$$reportNull$$$0(9);
        }
        return new JsInvocation((JsExpression)JS_OBJECT_CREATE_FUNCTION.deepCopy(), JsAstUtils.prototypeOf(referenceToClass));
    }

    @NotNull
    public static JsNameRef getCapturedVarAccessor(@NotNull JsExpression ref) {
        if (ref == null) {
            Namer.$$$reportNull$$$0(10);
        }
        JsNameRef result2 = new JsNameRef(CAPTURED_VAR_FIELD, ref);
        MetadataProperties.setSideEffects(result2, SideEffectKind.DEPENDS_ON_STATE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(11);
        }
        return jsNameRef;
    }

    @NotNull
    public static String isInstanceSuggestedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            Namer.$$$reportNull$$$0(12);
        }
        String string2 = "is" + NameSuggestion.sanitizeName(descriptor2.getName().getIdentifier());
        if (string2 == null) {
            Namer.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            Namer.$$$reportNull$$$0(14);
        }
        return new Namer(rootScope2);
    }

    private Namer(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            Namer.$$$reportNull$$$0(15);
        }
        this.kotlinScope = new JsObjectScope(rootScope2, "Kotlin standard object");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
    }

    @NotNull
    public static JsNameRef kotlin(@NotNull JsName name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$0(16);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(17);
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlin(@NotNull String name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$0(18);
        }
        return Namer.kotlin(this.kotlinScope.declareName(name2));
    }

    @NotNull
    public static JsNameRef kotlinObject() {
        JsNameRef jsNameRef = JsAstUtils.pureFqn(KOTLIN_NAME, null);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(19);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isTypeOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$0(20);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("isTypeOf", type2, TypeCheck.TYPEOF);
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$0(21);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("isInstanceOf", type2, TypeCheck.INSTANCEOF);
    }

    @NotNull
    public JsExpression orNull(@NotNull JsExpression callable) {
        if (callable == null) {
            Namer.$$$reportNull$$$0(22);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("orNull", callable, TypeCheck.OR_NULL);
    }

    @NotNull
    public JsExpression andPredicate(@NotNull JsExpression a, @NotNull JsExpression b) {
        if (a == null) {
            Namer.$$$reportNull$$$0(23);
        }
        if (b == null) {
            Namer.$$$reportNull$$$0(24);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("andPredicate", Arrays.asList(a, b), TypeCheck.AND_PREDICATE);
    }

    @NotNull
    public JsExpression isComparable() {
        JsNameRef jsNameRef = this.kotlin("isComparable");
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(25);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isCharSequence() {
        JsNameRef jsNameRef = this.kotlin(IS_CHAR_SEQUENCE);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(26);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isArray() {
        JsNameRef jsNameRef = this.kotlin("isArray");
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(27);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isPrimitiveArray(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$0(28);
        }
        JsNameRef jsNameRef = this.kotlin("is" + type2.getArrayTypeName().asString());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(29);
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @Nullable JsExpression argument2, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            Namer.$$$reportNull$$$0(30);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$0(31);
        }
        List<JsExpression> arguments2 = argument2 != null ? Collections.singletonList(argument2) : Collections.emptyList();
        return this.invokeFunctionAndSetTypeCheckMetadata(functionName, arguments2, metadata);
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @NotNull List<JsExpression> arguments2, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            Namer.$$$reportNull$$$0(32);
        }
        if (arguments2 == null) {
            Namer.$$$reportNull$$$0(33);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$0(34);
        }
        JsInvocation invocation = new JsInvocation((JsExpression)this.kotlin(functionName), new JsExpression[0]);
        invocation.getArguments().addAll(arguments2);
        MetadataProperties.setTypeCheck(invocation, metadata);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$0(35);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression isInstanceOf(@NotNull JsExpression instance2, @NotNull JsExpression type2) {
        if (instance2 == null) {
            Namer.$$$reportNull$$$0(36);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$0(37);
        }
        JsInvocation result2 = new JsInvocation((JsExpression)new JsNameRef("isType", KOTLIN_NAME), instance2, type2);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$0(38);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression getUndefinedExpression() {
        return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0));
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        JsExpression jsExpression = this.callGetProperty.deepCopy();
        if (jsExpression == null) {
            Namer.$$$reportNull$$$0(39);
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        JsExpression jsExpression = this.callSetProperty.deepCopy();
        if (jsExpression == null) {
            Namer.$$$reportNull$$$0(40);
        }
        return jsExpression;
    }

    public static JsNameRef kotlinLong() {
        return JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public static JsExpression createSpecialFunction(@NotNull SpecialFunction specialFunction) {
        if (specialFunction == null) {
            Namer.$$$reportNull$$$0(41);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(specialFunction.getSuggestedName(), (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(42);
        }
        return jsNameRef;
    }

    @NotNull
    public static String suggestedModuleName(@NotNull String id) {
        if (id == null) {
            Namer.$$$reportNull$$$0(43);
        }
        if (id.isEmpty()) {
            return ROOT_PACKAGE;
        }
        StringBuilder sb = new StringBuilder(id.length());
        char c = id.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
        }
        for (int i = 1; i < id.length(); ++i) {
            c = id.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        String string2 = sb.toString();
        if (string2 == null) {
            Namer.$$$reportNull$$$0(44);
        }
        return string2;
    }

    public static JsNameRef imul() {
        return JsAstUtils.pureFqn("imul", (JsExpression)Namer.kotlinObject());
    }

    public static boolean requiresEscaping(@NotNull String name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$0(45);
        }
        if (name2.isEmpty() || !Character.isJavaIdentifierStart(name2.charAt(0))) {
            return true;
        }
        for (int i = 1; i < name2.length(); ++i) {
            if (Character.isJavaIdentifierPart(name2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 16: 
            case 18: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionCallRef";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionApplyRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedVarAccessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceSuggestedName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlinObject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "isComparable";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = IS_CHAR_SEQUENCE;
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isArray";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "isPrimitiveArray";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceOf";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallGetProperty";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSetProperty";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecialFunction";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTag";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionCallRef";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionApplyRef";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createObjectWithPrototypeFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedVarAccessor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceSuggestedName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "kotlin";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOf";
                break;
            }
            case 21: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOf";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "orNull";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "andPredicate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveArray";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createSpecialFunction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "suggestedModuleName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "requiresEscaping";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

