/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsExternalArgumentCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "js.frontend"})
public final class JsExternalArgumentCallChecker
implements CallChecker {
    @NotNull
    public static final JsExternalArgumentCallChecker INSTANCE = new JsExternalArgumentCallChecker();

    private JsExternalArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            ClassDescriptor declaration2;
            KotlinType argumentType;
            KtExpression argExpression;
            ValueParameterDescriptor parameter2;
            if (CallUtilKt.getParameterForArgument(resolvedCall2, valueArgument) == null || !AnnotationsUtils.isJsExternalArgument(parameter2) || valueArgument.getArgumentExpression() == null || context2.getTrace().getBindingContext().getType(argExpression) == null) continue;
            ClassifierDescriptor classifierDescriptor = TypeUtilsKt.makeNotNullable(argumentType).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor2 == null || DescriptorUtilsKt.isEffectivelyExternal(declaration2 = classDescriptor2)) continue;
            context2.getTrace().report(ErrorsJs.JS_EXTERNAL_ARGUMENT.on(argExpression, argumentType));
        }
    }
}

