/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.incremental;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.incremental.storage.LookupMap;
import ksp.org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rJ\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u001f\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0086\u0002R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/incremental/TrackedLookupMap;", "", "lookupMap", "Lksp/org/jetbrains/kotlin/incremental/storage/LookupMap;", "trackChanges", "", "(Lorg/jetbrains/kotlin/incremental/storage/LookupMap;Z)V", "addedKeys", "", "Lksp/org/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "getAddedKeys", "()Ljava/util/Set;", "keys", "", "getKeys", "removedKeys", "getRemovedKeys", "append", "", "key", "fileIds", "", "get", "recordRemove", "recordSet", "remove", "set", "kotlin-build-common"})
final class TrackedLookupMap {
    @NotNull
    private final LookupMap lookupMap;
    private final boolean trackChanges;
    @Nullable
    private final Set<LookupSymbolKey> addedKeys;
    @Nullable
    private final Set<LookupSymbolKey> removedKeys;

    public TrackedLookupMap(@NotNull LookupMap lookupMap, boolean trackChanges) {
        Intrinsics.checkNotNullParameter(lookupMap, "lookupMap");
        this.lookupMap = lookupMap;
        this.trackChanges = trackChanges;
        this.addedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
        this.removedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
    }

    @Nullable
    public final Set<LookupSymbolKey> getAddedKeys() {
        return this.addedKeys;
    }

    @Nullable
    public final Set<LookupSymbolKey> getRemovedKeys() {
        return this.removedKeys;
    }

    @NotNull
    public final Set<LookupSymbolKey> getKeys() {
        return this.lookupMap.getKeys();
    }

    @Nullable
    public final Set<Integer> get(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.lookupMap.get(key);
    }

    public final void set(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fileIds, "fileIds");
        this.recordSet(key);
        this.lookupMap.set(key, fileIds);
    }

    public final void append(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fileIds, "fileIds");
        this.recordSet(key);
        this.lookupMap.append(key, fileIds);
    }

    public final void remove(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.recordRemove(key);
        this.lookupMap.remove(key);
    }

    private final void recordSet(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (!this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set = this.removedKeys;
            Intrinsics.checkNotNull(set);
            if (set.contains(lookupSymbolKey)) {
                this.removedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set2 = this.addedKeys;
                Intrinsics.checkNotNull(set2);
                set2.add(key);
            }
        }
    }

    private final void recordRemove(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set = this.addedKeys;
            Intrinsics.checkNotNull(set);
            if (set.contains(lookupSymbolKey)) {
                this.addedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set2 = this.removedKeys;
                Intrinsics.checkNotNull(set2);
                set2.add(key);
            }
        }
    }
}

