/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.incremental;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.util.containers.Interner;
import ksp.com.intellij.util.containers.MultiMap;
import ksp.org.jetbrains.kotlin.incremental.LookupSymbol;
import ksp.org.jetbrains.kotlin.incremental.components.LookupTracker;
import ksp.org.jetbrains.kotlin.incremental.components.Position;
import ksp.org.jetbrains.kotlin.incremental.components.ScopeKind;
import ksp.org.jetbrains.kotlin.utils.PlatformUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010,\u001a\u00020-H\u0016J0\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u00060\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lksp/org/jetbrains/kotlin/incremental/LookupTrackerImpl;", "Lksp/org/jetbrains/kotlin/incremental/components/LookupTracker;", "delegate", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;)V", "interner", "Lksp/com/intellij/util/containers/Interner;", "", "lookups", "Lksp/com/intellij/util/containers/MultiMap;", "Lksp/org/jetbrains/kotlin/incremental/LookupSymbol;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getLookups", "()Lcom/intellij/util/containers/MultiMap;", "pathInterner", "getPathInterner", "()Lcom/intellij/util/containers/Interner;", "prevFilePath", "getPrevFilePath", "()Ljava/lang/String;", "setPrevFilePath", "(Ljava/lang/String;)V", "prevName", "getPrevName", "setPrevName", "prevPosition", "Lksp/org/jetbrains/kotlin/incremental/components/Position;", "getPrevPosition", "()Lorg/jetbrains/kotlin/incremental/components/Position;", "setPrevPosition", "(Lorg/jetbrains/kotlin/incremental/components/Position;)V", "prevScopeFqName", "getPrevScopeFqName", "setPrevScopeFqName", "prevScopeKind", "Lksp/org/jetbrains/kotlin/incremental/components/ScopeKind;", "getPrevScopeKind", "()Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "setPrevScopeKind", "(Lorg/jetbrains/kotlin/incremental/components/ScopeKind;)V", "requiresPosition", "", "getRequiresPosition", "()Z", "clear", "", "record", "filePath", "position", "scopeFqName", "scopeKind", "name", "kotlin-build-common"})
public final class LookupTrackerImpl
implements LookupTracker {
    @NotNull
    private final LookupTracker delegate;
    @NotNull
    private final MultiMap<LookupSymbol, String> lookups;
    @NotNull
    private final Interner<String> pathInterner;
    @NotNull
    private final Interner<String> interner;
    @NotNull
    private String prevFilePath;
    @Nullable
    private Position prevPosition;
    @NotNull
    private String prevScopeFqName;
    @Nullable
    private ScopeKind prevScopeKind;
    @NotNull
    private String prevName;

    public LookupTrackerImpl(@NotNull LookupTracker delegate2) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        this.delegate = delegate2;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue(multiMap, "createSet(...)");
        this.lookups = multiMap;
        this.pathInterner = PlatformUtilsKt.createStringInterner();
        this.interner = PlatformUtilsKt.createStringInterner();
        this.prevFilePath = "";
        this.prevScopeFqName = "";
        this.prevName = "";
    }

    @NotNull
    public final MultiMap<LookupSymbol, String> getLookups() {
        return this.lookups;
    }

    @NotNull
    public final Interner<String> getPathInterner() {
        return this.pathInterner;
    }

    @Override
    public boolean getRequiresPosition() {
        return this.delegate.getRequiresPosition();
    }

    @NotNull
    public final String getPrevFilePath() {
        return this.prevFilePath;
    }

    public final void setPrevFilePath(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.prevFilePath = string2;
    }

    @Nullable
    public final Position getPrevPosition() {
        return this.prevPosition;
    }

    public final void setPrevPosition(@Nullable Position position) {
        this.prevPosition = position;
    }

    @NotNull
    public final String getPrevScopeFqName() {
        return this.prevScopeFqName;
    }

    public final void setPrevScopeFqName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.prevScopeFqName = string2;
    }

    @Nullable
    public final ScopeKind getPrevScopeKind() {
        return this.prevScopeKind;
    }

    public final void setPrevScopeKind(@Nullable ScopeKind scopeKind) {
        this.prevScopeKind = scopeKind;
    }

    @NotNull
    public final String getPrevName() {
        return this.prevName;
    }

    public final void setPrevName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.prevName = string2;
    }

    @Override
    public void record(@NotNull String filePath2, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name2) {
        boolean lookupChanged;
        boolean bl;
        boolean fqNameChanged;
        boolean bl2;
        boolean nameChanged;
        boolean bl3;
        Intrinsics.checkNotNullParameter(filePath2, "filePath");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(scopeFqName, "scopeFqName");
        Intrinsics.checkNotNullParameter((Object)scopeKind, "scopeKind");
        Intrinsics.checkNotNullParameter(name2, "name");
        if (!Intrinsics.areEqual(name2, this.prevName)) {
            String string2 = this.interner.intern(name2);
            Intrinsics.checkNotNullExpressionValue(string2, "intern(...)");
            this.prevName = string2;
            bl3 = true;
        } else {
            bl3 = nameChanged = false;
        }
        if (!Intrinsics.areEqual(scopeFqName, this.prevScopeFqName)) {
            String string3 = this.interner.intern(scopeFqName);
            Intrinsics.checkNotNullExpressionValue(string3, "intern(...)");
            this.prevScopeFqName = string3;
            bl2 = true;
        } else {
            bl2 = fqNameChanged = false;
        }
        if (!Intrinsics.areEqual(filePath2, this.prevFilePath)) {
            String string4 = this.pathInterner.intern(filePath2);
            Intrinsics.checkNotNullExpressionValue(string4, "intern(...)");
            this.prevFilePath = string4;
            bl = true;
        } else {
            bl = false;
        }
        boolean filePathChanged = bl;
        boolean bl4 = lookupChanged = nameChanged || fqNameChanged || filePathChanged;
        if (lookupChanged) {
            this.lookups.putValue(new LookupSymbol(this.prevName, this.prevScopeFqName), this.prevFilePath);
        }
        if (lookupChanged || !Intrinsics.areEqual(this.prevPosition, position) || this.prevScopeKind != scopeKind) {
            this.prevPosition = position;
            this.prevScopeKind = scopeKind;
            this.delegate.record(this.prevFilePath, position, this.prevScopeFqName, scopeKind, this.prevName);
        }
    }

    @Override
    public void clear() {
        this.lookups.clear();
        this.prevFilePath = "";
        this.prevPosition = null;
        this.prevScopeFqName = "";
        this.prevScopeKind = null;
        this.prevName = "";
    }
}

