/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import ksp.org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.util.PersistentMultimap;
import ksp.org.jetbrains.kotlin.name.Name;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BO\b\u0002\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00072\u001c\u0010\u001f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0 H\u0016J$\u0010#\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00072\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e0$H\u0016J(\u0010%\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00072\u0016\u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u001e0$H\u0016J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u0003R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lksp/org/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lksp/org/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "properties", "Lkotlinx/collections/immutable/PersistentMap;", "Lksp/org/jetbrains/kotlin/name/Name;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "functions", "Lksp/org/jetbrains/kotlin/fir/util/PersistentMultimap;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "classes", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "useSiteSession", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getClasses", "()Lkotlinx/collections/immutable/PersistentMap;", "getFunctions", "()Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "getProperties", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getCallableNames", "", "getClassifierNames", "mayContainName", "", "name", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lksp/org/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "storeBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "storeClass", "klass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "storeFunction", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "storeVariable", "variable", "Lksp/org/jetbrains/kotlin/fir/declarations/FirVariable;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirLocalScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1269#2,2:92\n1283#2,4:94\n*S KotlinDebug\n*F\n+ 1 FirLocalScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope\n*L\n81#1:92,2\n81#1:94,4\n*E\n"})
public final class FirLocalScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final PersistentMap<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final PersistentMultimap<Name, FirNamedFunctionSymbol> functions;
    @NotNull
    private final PersistentMap<Name, FirRegularClassSymbol> classes;
    @NotNull
    private final FirSession useSiteSession;

    private FirLocalScope(PersistentMap<Name, ? extends FirVariableSymbol<?>> properties2, PersistentMultimap<Name, FirNamedFunctionSymbol> functions2, PersistentMap<Name, FirRegularClassSymbol> classes2, FirSession useSiteSession) {
        this.properties = properties2;
        this.functions = functions2;
        this.classes = classes2;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final PersistentMap<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final PersistentMultimap<Name, FirNamedFunctionSymbol> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final PersistentMap<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    public FirLocalScope(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this(ExtensionsKt.persistentMapOf(new Pair[0]), new PersistentMultimap<Name, FirNamedFunctionSymbol>(), ExtensionsKt.persistentMapOf(new Pair[0]), session2);
    }

    @NotNull
    public final FirLocalScope storeClass(@NotNull FirRegularClass klass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(session2, "session");
        return new FirLocalScope(this.properties, this.functions, this.classes.put(klass.getName(), klass.getSymbol()), session2);
    }

    @NotNull
    public final FirLocalScope storeFunction(@NotNull FirSimpleFunction function2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(session2, "session");
        return new FirLocalScope(this.properties, this.functions.put(function2.getName(), function2.getSymbol()), this.classes, session2);
    }

    @NotNull
    public final FirLocalScope storeVariable(@NotNull FirVariable variable2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        Intrinsics.checkNotNullParameter(session2, "session");
        return new FirLocalScope(this.properties.put(variable2.getName(), variable2.getSymbol()), this.functions, this.classes, session2);
    }

    @NotNull
    public final FirLocalScope storeBackingField(@NotNull FirProperty property, @NotNull FirSession session2) {
        PersistentMap<Name, Object> enhancedProperties;
        PersistentMap<Name, Object> persistentMap;
        PersistentMap<Name, Object> persistentMap2;
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(session2, "session");
        Object object = property.getBackingField();
        if (object != null && (object = ((FirBackingField)object).getSymbol()) != null) {
            Object it = object;
            boolean bl = false;
            persistentMap2 = this.properties.put(StandardNames.BACKING_FIELD, (FirVariableSymbol<?>)it);
        } else {
            persistentMap2 = null;
        }
        if ((persistentMap = (enhancedProperties = persistentMap2)) == null) {
            persistentMap = this.properties;
        }
        return new FirLocalScope(persistentMap, this.functions, this.classes, session2);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        for (FirNamedFunctionSymbol function2 : this.functions.get(name2)) {
            processor2.invoke(function2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        FirVariableSymbol property = (FirVariableSymbol)this.properties.get(name2);
        if (property != null) {
            processor2.invoke(property);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        FirRegularClassSymbol klass = (FirRegularClassSymbol)this.classes.get(name2);
        if (klass != null) {
            Iterable $this$associateWith$iv = klass.getTypeParameterSymbols();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                ConeTypeParameterType coneTypeParameterType = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it);
                map.put(t, coneTypeParameterType);
            }
            Map substitution = result$iv;
            processor2.invoke(klass, new ConeSubstitutorByMap(substitution, this.useSiteSession));
        }
    }

    @Override
    public boolean mayContainName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.properties.containsKey(name2) || !((Collection)this.functions.get(name2)).isEmpty() || this.classes.containsKey(name2);
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.properties.keySet(), (Iterable)this.functions.getKeys());
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.classes.keySet();
    }
}

