/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.TypeVariableAsExplicitReceiver;
import ksp.org.jetbrains.kotlin.fir.resolve.inference.FirDelegatedPropertyInferenceSessionKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/TypeVariablesInExplicitReceivers;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkOtherCases", "obtainTypeVariable", "Lksp/org/jetbrains/kotlin/fir/types/ConeTypeVariableType;", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/TypeVariablesInExplicitReceivers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,827:1\n1#2:828\n*E\n"})
public final class TypeVariablesInExplicitReceivers
extends ResolutionStage {
    @NotNull
    public static final TypeVariablesInExplicitReceivers INSTANCE = new TypeVariablesInExplicitReceivers();

    private TypeVariablesInExplicitReceivers() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        if (FirDelegatedPropertyInferenceSessionKt.isAnyOfDelegateOperators(callInfo.getCallSite())) {
            return Unit.INSTANCE;
        }
        FirExpression firExpression2 = callInfo.getExplicitReceiver();
        if (firExpression2 == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        FirExpression explicitReceiver = firExpression2;
        ConeTypeVariableType coneTypeVariableType = this.obtainTypeVariable(FirTypeUtilsKt.getResolvedType(explicitReceiver));
        if (coneTypeVariableType == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        ConeTypeVariableType typeVariableType = coneTypeVariableType;
        TypeParameterMarker typeParameterMarker = typeVariableType.getTypeConstructor().getOriginalTypeParameter();
        Object object = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
        if (object == null || (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) == null || (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        Object typeParameter = object;
        sink.reportDiagnostic(new TypeVariableAsExplicitReceiver(explicitReceiver, (FirTypeParameter)typeParameter));
        return Unit.INSTANCE;
    }

    private final void checkOtherCases(Candidate candidate2) {
        Object object = candidate2.chosenExtensionReceiverExpression();
        if (!((object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? this.obtainTypeVariable((ConeKotlinType)object) : null) == null)) {
            boolean $i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32 = false;
            String $i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32 = "Found TV in extension receiver of " + candidate2;
            throw new IllegalArgumentException($i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32.toString());
        }
        Object object2 = candidate2.dispatchReceiverExpression();
        if (!((object2 != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null ? this.obtainTypeVariable((ConeKotlinType)object2) : null) == null)) {
            boolean bl = false;
            String string2 = "Found TV in dispatch receiver of " + candidate2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final ConeTypeVariableType obtainTypeVariable(ConeKotlinType $this$obtainTypeVariable) {
        ConeTypeVariableType coneTypeVariableType;
        block9: {
            ConeKotlinType coneKotlinType = $this$obtainTypeVariable;
            if (coneKotlinType instanceof ConeFlexibleType) {
                coneTypeVariableType = this.obtainTypeVariable(((ConeFlexibleType)$this$obtainTypeVariable).getLowerBound());
            } else if (coneKotlinType instanceof ConeTypeVariableType) {
                coneTypeVariableType = (ConeTypeVariableType)$this$obtainTypeVariable;
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                coneTypeVariableType = this.obtainTypeVariable(((ConeDefinitelyNotNullType)$this$obtainTypeVariable).getOriginal());
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                for (ConeKotlinType it : (Iterable)((ConeIntersectionType)$this$obtainTypeVariable).getIntersectedTypes()) {
                    boolean bl = false;
                    ConeTypeVariableType coneTypeVariableType2 = INSTANCE.obtainTypeVariable(it);
                    if (coneTypeVariableType2 == null) continue;
                    coneTypeVariableType = coneTypeVariableType2;
                    break block9;
                }
                coneTypeVariableType = null;
            } else {
                coneTypeVariableType = null;
            }
        }
        return coneTypeVariableType;
    }
}

