/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import ksp.org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "receiverExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getReceiverExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "scope", "Lksp/org/jetbrains/kotlin/fir/scopes/FirTypeScope;", "useSiteSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirReceivers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReceivers.kt\norg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,311:1\n44#2:312\n*S KotlinDebug\n*F\n+ 1 FirReceivers.kt\norg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue\n*L\n58#1:312\n*E\n"})
public final class ExpressionReceiverValue
extends ReceiverValue {
    @NotNull
    private final FirExpression receiverExpression;

    public ExpressionReceiverValue(@NotNull FirExpression receiverExpression) {
        Intrinsics.checkNotNullParameter(receiverExpression, "receiverExpression");
        this.receiverExpression = receiverExpression;
    }

    @Override
    @NotNull
    public FirExpression getReceiverExpression() {
        return this.receiverExpression;
    }

    @Override
    @NotNull
    public ConeKotlinType getType() {
        return FirTypeUtilsKt.getResolvedType(this.getReceiverExpression());
    }

    @Override
    @Nullable
    public FirTypeScope scope(@NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirExpression receiverExpr = this.getReceiverExpression();
        if (receiverExpr instanceof FirCheckNotNullCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)receiverExpr);
            boolean $i$f$getArguments = false;
            receiverExpr = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        }
        if (receiverExpr instanceof FirSmartCastExpression) {
            return ScopeUtilsKt.smartcastScope((FirSmartCastExpression)receiverExpr, useSiteSession, scopeSession, FirResolvePhase.STATUS);
        }
        return ScopeUtilsKt.scope(this.getType(), useSiteSession, scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
    }
}

