/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.renderer;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.renderer.FirPrinter;
import ksp.org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import ksp.org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import ksp.org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u0010*\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0014J\f\u0010&\u001a\u00020\u0010*\u00020\u0019H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/FirModifierRenderer;", "", "()V", "components", "Lksp/org/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "printer", "Lksp/org/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "renderModifier", "", "modifier", "", "renderModifiers", "anonymousFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "backingField", "Lksp/org/jetbrains/kotlin/fir/declarations/FirBackingField;", "constructor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirConstructor;", "memberDeclaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "propertyAccessor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "typeParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "valueParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "functionTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "asString", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "effectiveVisibility", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "modalityAsString", "Companion", "tree"})
@SourceDebugExtension(value={"SMAP\nFirModifierRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirModifierRenderer.kt\norg/jetbrains/kotlin/fir/renderer/FirModifierRenderer\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,83:1\n11#2:84\n40#2:85\n*S KotlinDebug\n*F\n+ 1 FirModifierRenderer.kt\norg/jetbrains/kotlin/fir/renderer/FirModifierRenderer\n*L\n68#1:84\n69#1:85\n*E\n"})
public abstract class FirModifierRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public FirRendererComponents components;
    @NotNull
    private static final Set<Visibility> visibilitiesToRenderEffectiveSet;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    @NotNull
    protected final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    public abstract void renderModifiers(@NotNull FirMemberDeclaration var1);

    public abstract void renderModifiers(@NotNull FirBackingField var1);

    public abstract void renderModifiers(@NotNull FirConstructor var1);

    public abstract void renderModifiers(@NotNull FirPropertyAccessor var1);

    public abstract void renderModifiers(@NotNull FirAnonymousFunction var1);

    public void renderModifiers(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        if (valueParameter2.isCrossinline()) {
            this.renderModifier("crossinline");
        }
        if (valueParameter2.isNoinline()) {
            this.renderModifier("noinline");
        }
        if (valueParameter2.isVararg()) {
            this.renderModifier("vararg");
        }
    }

    public void renderModifiers(@NotNull FirTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        if (typeParameter.isReified()) {
            this.renderModifier("reified");
        }
    }

    public void renderModifiers(@NotNull FirFunctionTypeRef functionTypeRef) {
        Intrinsics.checkNotNullParameter(functionTypeRef, "functionTypeRef");
        if (functionTypeRef.isSuspend()) {
            this.renderModifier("suspend");
        }
    }

    protected void renderModifier(@NotNull String modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        Object[] objectArray = new Object[]{modifier + ' '};
        this.getPrinter().print(objectArray);
    }

    @NotNull
    protected String asString(@NotNull Visibility $this$asString, @Nullable EffectiveVisibility effectiveVisibility) {
        Intrinsics.checkNotNullParameter($this$asString, "<this>");
        if (Intrinsics.areEqual($this$asString, Visibilities.Unknown.INSTANCE)) {
            return "public?";
        }
        String itself = $this$asString.toString();
        if (effectiveVisibility == null) {
            return itself;
        }
        Visibility effectiveAsVisibility = effectiveVisibility.toVisibility();
        if (Intrinsics.areEqual(effectiveAsVisibility, $this$asString)) {
            return itself;
        }
        if (Intrinsics.areEqual(effectiveAsVisibility, Visibilities.Private.INSTANCE) && Intrinsics.areEqual($this$asString, Visibilities.PrivateToThis.INSTANCE)) {
            return itself;
        }
        if (!visibilitiesToRenderEffectiveSet.contains($this$asString)) {
            return itself;
        }
        return itself + '[' + effectiveVisibility.getName() + ']';
    }

    public static /* synthetic */ String asString$default(FirModifierRenderer firModifierRenderer, Visibility visibility2, EffectiveVisibility effectiveVisibility, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asString");
        }
        if ((n & 1) != 0) {
            effectiveVisibility = null;
        }
        return firModifierRenderer.asString(visibility2, effectiveVisibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected String modalityAsString(@NotNull FirMemberDeclaration $this$modalityAsString) {
        Intrinsics.checkNotNullParameter($this$modalityAsString, "<this>");
        FirMemberDeclaration $this$modality$iv = $this$modalityAsString;
        boolean $i$f$getModality = false;
        Object object = $this$modality$iv.getStatus().getModality();
        if (object != null && (object = object.name()) != null) {
            String string2 = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)object);
            object = string2;
            if (string2 != null) return object;
        }
        FirMemberDeclaration $this$modalityAsString_u24lambda_u240 = $this$modalityAsString;
        boolean bl = false;
        if (!($this$modalityAsString_u24lambda_u240 instanceof FirCallableDeclaration)) return "final?";
        FirMemberDeclaration $this$isOverride$iv = $this$modalityAsString_u24lambda_u240;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) return "final?";
        return "open?";
    }

    static {
        Visibility[] visibilityArray = new Visibility[]{Visibilities.Private.INSTANCE, Visibilities.PrivateToThis.INSTANCE, Visibilities.Internal.INSTANCE, Visibilities.Protected.INSTANCE, Visibilities.Public.INSTANCE, Visibilities.Local.INSTANCE};
        visibilitiesToRenderEffectiveSet = SetsKt.setOf(visibilityArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/FirModifierRenderer$Companion;", "", "()V", "visibilitiesToRenderEffectiveSet", "", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "tree"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

