/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import ksp.org.jetbrains.kotlin.fir.backend.LeakedDeclarationCaches;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ1\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0019\u0010\u001e\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u001d0\u001f\u00a2\u0006\u0002\b H\u0082\b\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\rJ\u0016\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0011J\u0016\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0015J\u0016\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "()V", "cacheStack", "", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "lastCache", "getLastCache$annotations", "getLastCache", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "enterCallable", "", "getDelegatedProperty", "Lksp/org/jetbrains/kotlin/ir/symbols/IrLocalDelegatedPropertySymbol;", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "getLocalFunctionSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "parameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lksp/org/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "variable", "Lksp/org/jetbrains/kotlin/fir/declarations/FirVariable;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "leaveCallable", "putDelegatedProperty", "firProperty", "irPropertySymbol", "putLocalFunction", "firFunction", "irFunctionSymbol", "putParameter", "firParameter", "irParameterSymbol", "putVariable", "firVariable", "irVariableSymbol", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n52#1,2:75\n55#1:78\n52#1,2:79\n55#1:82\n52#1,2:83\n55#1:86\n1#2:77\n1#2:81\n1#2:85\n1#2:87\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n40#1:75,2\n40#1:78\n44#1:79,2\n44#1:82\n48#1:83,2\n48#1:86\n40#1:77\n44#1:81\n48#1:85\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    @NotNull
    public final Fir2IrScopeCache getLastCache() {
        return CollectionsKt.last(this.cacheStack);
    }

    @LeakedDeclarationCaches
    public static /* synthetic */ void getLastCache$annotations() {
    }

    public final void leaveCallable() {
        CollectionsKt.last(this.cacheStack).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameterSymbol getParameter(@NotNull FirValueParameter parameter2) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameterSymbol local = cache2.getParameter(parameter2);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariableSymbol getVariable(@NotNull FirVariable variable2) {
        IrVariableSymbol irVariableSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrVariableSymbol irVariableSymbol2 = $this$getVariable_u24lambda_u240.getVariable(variable2);
                if (irVariableSymbol2 == null) continue;
                IrVariableSymbol it$iv = irVariableSymbol2;
                boolean bl2 = false;
                irVariableSymbol = it$iv;
                break block1;
            }
            irVariableSymbol = null;
        }
        return irVariableSymbol;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunctionSymbol(@NotNull FirFunction localFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(localFunction, "localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunctionSymbol_u24lambda_u241 = cache$iv = iterator2.next();
                boolean bl = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = $this$getLocalFunctionSymbol_u24lambda_u241.getLocalFunction(localFunction);
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv = irSimpleFunctionSymbol2;
                boolean bl2 = false;
                irSimpleFunctionSymbol = it$iv;
                break block1;
            }
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    @Nullable
    public final IrLocalDelegatedPropertySymbol getDelegatedProperty(@NotNull FirProperty property) {
        IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol;
        block1: {
            Intrinsics.checkNotNullParameter(property, "property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = iterator2.next();
                boolean bl = false;
                IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property);
                if (irLocalDelegatedPropertySymbol2 == null) continue;
                IrLocalDelegatedPropertySymbol it$iv = irLocalDelegatedPropertySymbol2;
                boolean bl2 = false;
                irLocalDelegatedPropertySymbol = it$iv;
                break block1;
            }
            irLocalDelegatedPropertySymbol = null;
        }
        return irLocalDelegatedPropertySymbol;
    }

    private final <T> T last(Function1<? super Fir2IrScopeCache, ? extends T> getter2) {
        boolean $i$f$last = false;
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            T t = getter2.invoke(cache2);
            if (t == null) continue;
            T it = t;
            boolean bl = false;
            return it;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameterSymbol irParameterSymbol) {
        Intrinsics.checkNotNullParameter(firParameter, "firParameter");
        Intrinsics.checkNotNullParameter(irParameterSymbol, "irParameterSymbol");
        CollectionsKt.last(this.cacheStack).putParameter(firParameter, irParameterSymbol);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariableSymbol irVariableSymbol) {
        Intrinsics.checkNotNullParameter(firVariable, "firVariable");
        Intrinsics.checkNotNullParameter(irVariableSymbol, "irVariableSymbol");
        CollectionsKt.last(this.cacheStack).putVariable(firVariable, irVariableSymbol);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunctionSymbol irFunctionSymbol) {
        Intrinsics.checkNotNullParameter(firFunction, "firFunction");
        Intrinsics.checkNotNullParameter(irFunctionSymbol, "irFunctionSymbol");
        CollectionsKt.last(this.cacheStack).putLocalFunction(firFunction, irFunctionSymbol);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedPropertySymbol irPropertySymbol) {
        Intrinsics.checkNotNullParameter(firProperty, "firProperty");
        Intrinsics.checkNotNullParameter(irPropertySymbol, "irPropertySymbol");
        CollectionsKt.last(this.cacheStack).putDelegatedProperty(firProperty, irPropertySymbol);
    }
}

