/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import ksp.org.jetbrains.kotlin.fir.backend.InjectedValue;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrMemberWithContainerSource;
import ksp.org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001$J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006%\u00c0\u0006\u0001"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "irNeedsDeserialization", "", "getIrNeedsDeserialization", "()Z", "parametersAreAssignable", "getParametersAreAssignable", "deserializeToplevelClass", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "findInjectedValue", "Lksp/org/jetbrains/kotlin/fir/backend/InjectedValue;", "calleeReference", "Lksp/org/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "generateOrGetFacadeClass", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "hasBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "registerDeclarations", "", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "Default", "fir2ir"})
public interface Fir2IrExtensions {
    public boolean getIrNeedsDeserialization();

    public boolean getParametersAreAssignable();

    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions();

    @Nullable
    public IrClass generateOrGetFacadeClass(@NotNull IrMemberWithContainerSource var1, @NotNull Fir2IrComponents var2);

    public boolean deserializeToplevelClass(@NotNull IrClass var1, @NotNull Fir2IrComponents var2);

    public void registerDeclarations(@NotNull SymbolTable var1);

    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference var1, @NotNull Fir2IrConversionScope var2);

    public boolean hasBackingField(@NotNull FirProperty var1, @NotNull FirSession var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions$Default;", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "()V", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "irNeedsDeserialization", "", "getIrNeedsDeserialization", "()Z", "parametersAreAssignable", "getParametersAreAssignable", "deserializeToplevelClass", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "findInjectedValue", "", "calleeReference", "Lksp/org/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "generateOrGetFacadeClass", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "hasBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "registerDeclarations", "", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "fir2ir"})
    public static final class Default
    implements Fir2IrExtensions {
        @NotNull
        public static final Default INSTANCE = new Default();
        @NotNull
        private static final List<IrExternalOverridabilityCondition> externalOverridabilityConditions = CollectionsKt.emptyList();

        private Default() {
        }

        @Override
        public boolean getIrNeedsDeserialization() {
            return false;
        }

        @Override
        public boolean getParametersAreAssignable() {
            return false;
        }

        @Override
        @NotNull
        public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
            return externalOverridabilityConditions;
        }

        @Override
        @Nullable
        public IrClass generateOrGetFacadeClass(@NotNull IrMemberWithContainerSource declaration2, @NotNull Fir2IrComponents components2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(components2, "components");
            return null;
        }

        @Override
        public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components2) {
            Intrinsics.checkNotNullParameter(irClass, "irClass");
            Intrinsics.checkNotNullParameter(components2, "components");
            return false;
        }

        @Override
        public void registerDeclarations(@NotNull SymbolTable symbolTable) {
            Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        }

        @Nullable
        public Void findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
            Intrinsics.checkNotNullParameter(calleeReference, "calleeReference");
            Intrinsics.checkNotNullParameter(conversionScope, "conversionScope");
            return null;
        }

        @Override
        public boolean hasBackingField(@NotNull FirProperty property, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(session2, "session");
            return DeclarationAttributesKt.getHasBackingField(property);
        }
    }
}

