/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsCodeHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsExportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration.FirWasmJsInteropTypesCheckerKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import ksp.org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.WasmStandardClassIds;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsInteropTypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsInteropTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,158:1\n1745#2,2:159\n1747#2:163\n60#3:161\n37#4:162\n*S KotlinDebug\n*F\n+ 1 FirWasmJsInteropTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker\n*L\n50#1:159,2\n50#1:163\n50#1:161\n50#1:162\n*E\n"})
public final class FirWasmJsInteropTypesChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirWasmJsInteropTypesChecker INSTANCE = new FirWasmJsInteropTypesChecker();

    private FirWasmJsInteropTypesChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context2.getSession();
        if (!(FirWasmJsInteropTypesChecker.check$isExternalJsInteropDeclaration(declaration2, session2) || FirWasmJsInteropTypesChecker.check$isJsCodeDeclaration(declaration2) || FirWasmJsInteropTypesChecker.check$isJsExportDeclaration(declaration2, session2))) {
            return;
        }
        Iterable $this$any$iv = context2.getContainingDeclarations();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl2 = false;
                if (it instanceof FirClass) {
                    FirClass $this$isEnumClass$iv = (FirClass)it;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) {
                        return;
                    }
                    boolean bl3 = false;
                    if (bl3) {
                        return;
                    }
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (declaration2 instanceof FirMemberDeclaration) {
            object = ((FirMemberDeclaration)declaration2).getTypeParameters().iterator();
            while (object.hasNext()) {
                FirTypeParameterRef typeParameter = (FirTypeParameterRef)object.next();
                FirWasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter, session2, reporter, context2);
            }
        }
        if ((object = declaration2) instanceof FirProperty) {
            FirWasmJsInteropTypesChecker.check$checkJsInteropType$default(FirTypeUtilsKt.getConeType(((FirProperty)declaration2).getReturnTypeRef()), session2, reporter, context2, "JS interop property", declaration2.getSource(), false, 32, null);
            return;
        } else {
            if (!(object instanceof FirFunction)) return;
            for (FirValueParameter parameter2 : ((FirFunction)declaration2).getValueParameters()) {
                ConeKotlinType type2 = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
                ConeKotlinType varargElementTypeOrType = parameter2.isVararg() ? ArrayUtilsKt.varargElementType(type2) : type2;
                FirWasmJsInteropTypesChecker.check$checkJsInteropType$default(varargElementTypeOrType, session2, reporter, context2, "JS interop function parameter", parameter2.getSource(), false, 32, null);
            }
            FirWasmJsInteropTypesChecker.check$checkJsInteropType(FirTypeUtilsKt.getConeType(((FirFunction)declaration2).getReturnTypeRef()), session2, reporter, context2, "JS interop function return", declaration2.getSource(), true);
        }
    }

    private static final boolean check$isExternalJsInteropDeclaration(FirDeclaration $declaration, FirSession session2) {
        return FirWebCommonHelpersKt.isEffectivelyExternal($declaration.getSymbol(), session2) && !FirAnnotationUtilsKt.hasAnnotation($declaration.getAnnotations(), WasmStandardClassIds.Annotations.WasmImport, session2);
    }

    private static final boolean check$isJsCodeDeclaration(FirDeclaration $declaration) {
        return $declaration instanceof FirSimpleFunction && FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirSimpleFunction)$declaration) || $declaration instanceof FirProperty && FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirProperty)$declaration);
    }

    private static final boolean check$isJsExportDeclaration(FirDeclaration $declaration, FirSession session2) {
        return $declaration instanceof FirSimpleFunction && FirWasmJsExportHelpersKt.isJsExportedDeclaration($declaration, session2);
    }

    private static final void check$checkJsInteropType(ConeKotlinType $this$check_u24checkJsInteropType, FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, String typePositionDescription, KtSourceElement source, boolean isInFunctionReturnPosition) {
        if (!FirWasmJsInteropTypesCheckerKt.access$isTypeSupportedInJsInterop($this$check_u24checkJsInteropType, isInFunctionReturnPosition, session2)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getWRONG_JS_INTEROP_TYPE(), (Object)typePositionDescription, (Object)$this$check_u24checkJsInteropType, (DiagnosticContext)$context, null, 32, null);
        }
    }

    static /* synthetic */ void check$checkJsInteropType$default(ConeKotlinType coneKotlinType, FirSession firSession, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, String string2, KtSourceElement ktSourceElement, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        FirWasmJsInteropTypesChecker.check$checkJsInteropType(coneKotlinType, firSession, diagnosticReporter, checkerContext, string2, ktSourceElement, bl);
    }

    private static final void check$checkJsInteropTypeParameter(FirTypeParameterRef $this$check_u24checkJsInteropTypeParameter, FirSession session2, DiagnosticReporter $reporter, CheckerContext $context) {
        for (FirResolvedTypeRef upperBound : $this$check_u24checkJsInteropTypeParameter.getSymbol().getResolvedBounds()) {
            ConeKotlinType coneKotlinType = upperBound.getType();
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = $this$check_u24checkJsInteropTypeParameter.getSource();
            }
            FirWasmJsInteropTypesChecker.check$checkJsInteropType$default(coneKotlinType, session2, $reporter, $context, "JS interop type parameter upper bound", ktSourceElement, false, 32, null);
        }
    }
}

