/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.name.NativeStandardInteropNames;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCOverrideInitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCOverrideInitChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n37#2:97\n1724#3,3:98\n764#3:101\n855#3,2:102\n1853#3,2:104\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCOverrideInitChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker\n*L\n91#1:97\n40#1:98,3\n47#1:101\n47#1:102,2\n72#1:104,2\n*E\n"})
public final class FirNativeObjCOverrideInitChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOverrideInitChecker INSTANCE = new FirNativeObjCOverrideInitChecker();

    private FirNativeObjCOverrideInitChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration2.getSymbol(), context2.getSession())) {
            FirNativeObjCOverrideInitChecker.check$checkKotlinObjCClass(session2, reporter, context2, declaration2);
        }
    }

    private static final List<FirConstructorSymbol> check$constructors(FirClassSymbol<?> $this$check_u24constructors, FirSession session2) {
        List result2 = new ArrayList();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(session2, $this$check_u24constructors, null).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)new Function1<FirConstructorSymbol, Unit>((List<FirConstructorSymbol>)result2){
            final /* synthetic */ List<FirConstructorSymbol> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(FirConstructorSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ((Collection)this.$result).add(it);
            }
        });
        return result2;
    }

    private static final boolean check$overridesConstructor(FirConstructorSymbol $this$check_u24overridesConstructor, FirConstructorSymbol other) {
        boolean bl;
        block4: {
            List<FirValueParameterSymbol> aParams = $this$check_u24overridesConstructor.getValueParameterSymbols();
            List<FirValueParameterSymbol> bParams = other.getValueParameterSymbols();
            if (aParams.size() != bParams.size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)aParams, (Iterable)bParams);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirValueParameterSymbol thisParameter = (FirValueParameterSymbol)pair.component1();
                    FirValueParameterSymbol otherParameter = (FirValueParameterSymbol)pair.component2();
                    if (Intrinsics.areEqual(thisParameter.getName(), otherParameter.getName()) && Intrinsics.areEqual(thisParameter.getResolvedReturnType(), otherParameter.getResolvedReturnType())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$checkCanGenerateOverrideInit(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass, FirConstructor constructor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull(firClass, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        FirRegularClassSymbol superClass = SupertypeUtilsKt.getSuperClassSymbolOrAny(((FirRegularClass)firClass).getSymbol(), session2);
        Iterable $this$filter$iv = FirNativeObjCOverrideInitChecker.check$constructors(superClass, session2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirConstructorSymbol it = (FirConstructorSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirNativeObjCOverrideInitChecker.check$overridesConstructor(constructor2.getSymbol(), it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superConstructors = CollectionsKt.toList((List)destination$iv$iv);
        FirConstructorSymbol firConstructorSymbol2 = (FirConstructorSymbol)CollectionsKt.singleOrNull(superConstructors);
        if (firConstructorSymbol2 == null) {
            FirNativeObjCOverrideInitChecker $this$check_u24checkCanGenerateOverrideInit_u24lambda_u242 = INSTANCE;
            boolean bl = false;
            if (superConstructors.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_DOES_NOT_OVERRIDE_ANY_SUPER_CONSTRUCTOR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_MATCHES_SEVERAL_SUPER_CONSTRUCTORS(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            }
            return;
        }
        FirConstructorSymbol superConstructor = firConstructorSymbol2;
        FirFunctionSymbol<?> firFunctionSymbol = FirObjCInteropKt.getObjCInitMethod(superConstructor, session2);
        Intrinsics.checkNotNull(firFunctionSymbol);
        FirFunctionSymbol<?> initMethod = firFunctionSymbol;
        Iterable $this$forEach$iv = firClass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirSimpleFunction) || !FirHelpersKt.getDirectOverriddenSymbols((FirCallableDeclaration)it, $context).contains(initMethod) || ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableDeclaration)it)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_OVERRIDES_ALREADY_OVERRIDDEN_OBJC_INITIALIZER(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
        }
    }

    private static final void check$checkKotlinObjCClass(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirConstructor) || !FirAnnotationUtilsKt.hasAnnotation(decl.getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId(), session2)) continue;
            FirNativeObjCOverrideInitChecker.check$checkCanGenerateOverrideInit(session2, $reporter, $context, firClass, (FirConstructor)decl);
        }
    }
}

