/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirExpressionJavaNullabilityWarningCheckersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirPropertyJavaNullabilityWarningChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirPropertyJavaNullabilityWarningChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyJavaNullabilityWarningChecker INSTANCE = new FirPropertyJavaNullabilityWarningChecker();

    private FirPropertyJavaNullabilityWarningChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (!DeclarationUtilsKt.getHasExplicitReturnType(declaration2.getSymbol())) break block1;
            FirExpression firExpression2 = declaration2.getInitializer();
            if (firExpression2 != null) {
                FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(firExpression2, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), reporter, context2, FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
            }
        }
    }
}

