/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableName;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsBuiltinNameClashChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "PROHIBITED_MEMBER_NAMES", "", "", "PROHIBITED_STATIC_NAMES", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public final class FirJsBuiltinNameClashChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsBuiltinNameClashChecker INSTANCE = new FirJsBuiltinNameClashChecker();
    @NotNull
    private static final Set<String> PROHIBITED_STATIC_NAMES;
    @NotNull
    private static final Set<String> PROHIBITED_MEMBER_NAMES;

    private FirJsBuiltinNameClashChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (FirJsHelpersKt.isNativeObject(declaration2.getSymbol(), context2.getSession())) {
            return;
        }
        if (FirHelpersKt.getContainingClassSymbol(declaration2, context2.getSession()) == null) {
            return;
        }
        FirJsStableName firJsStableName = FirJsStableName.Companion.createStableNameOrNull(declaration2.getSymbol(), context2.getSession());
        if (firJsStableName == null) {
            return;
        }
        FirJsStableName stableName = firJsStableName;
        if (declaration2 instanceof FirClassLikeDeclaration && PROHIBITED_STATIC_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Function." + stableName), (DiagnosticContext)context2, null, 16, null);
        }
        if (declaration2 instanceof FirCallableDeclaration && PROHIBITED_MEMBER_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Object.prototype." + stableName), (DiagnosticContext)context2, null, 16, null);
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }
}

