/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirArrayOfNothingQualifierChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirArrayOfNothingTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirArrayOfNothingTypeChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirArrayOfNothingTypeChecker INSTANCE = new FirArrayOfNothingTypeChecker();

    private FirArrayOfNothingTypeChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isVararg2;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirTypeAlias) {
            return;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(typeRef);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType coneType = coneKotlinType;
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, context2.getSession());
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirValueParameter firValueParameter = firDeclaration instanceof FirValueParameter ? (FirValueParameter)firDeclaration : null;
        boolean bl = isVararg2 = firValueParameter != null ? firValueParameter.isVararg() : false;
        if (!isVararg2 && FirArrayOfNothingQualifierChecker.INSTANCE.isArrayOfNothing(fullyExpandedType2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Array<Nothing> is illegal", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

