/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirImport;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0011H\u0002\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "()V", "checkPsiOrLightTree", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isClassIdPointingToEnumEntry", "", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "symbolProvider", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "processPossiblyUnresolvedImport", "import", "Lksp/org/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getOutermostClassName", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnresolvedInMiddleOfImportChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n75#3:101\n37#4:102\n1745#5,3:103\n*S KotlinDebug\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n*L\n95#1:101\n95#1:102\n96#1:103,3\n*E\n"})
public final class FirUnresolvedInMiddleOfImportChecker
extends FirDeclarationSyntaxChecker<FirFile, KtFile> {
    @NotNull
    public static final FirUnresolvedInMiddleOfImportChecker INSTANCE = new FirUnresolvedInMiddleOfImportChecker();

    private FirUnresolvedInMiddleOfImportChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFile element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirImport firImport : element2.getImports()) {
            if (!(firImport instanceof FirResolvedImport)) continue;
            this.processPossiblyUnresolvedImport((FirResolvedImport)firImport, context2, reporter);
        }
    }

    private final void processPossiblyUnresolvedImport(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = firResolvedImport.getSource();
        boolean bl = object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false;
        if (bl) {
            return;
        }
        ClassId classId = firResolvedImport.getResolvedParentClassId();
        if (classId == null) {
            return;
        }
        ClassId referencedClass = classId;
        PackageResolutionResult importResolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), referencedClass);
        if (!(importResolutionResult instanceof PackageResolutionResult.Error)) {
            return;
        }
        ConeDiagnostic diagnostic = ((PackageResolutionResult.Error)importResolutionResult).getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedParentInImport) {
            KtSourceElement ktSourceElement = firResolvedImport.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context2.getSession());
            ClassId parentClassId = ((ConeUnresolvedParentInImport)diagnostic).getParentClassId();
            if (firResolvedImport.isAllUnder() && this.isClassIdPointingToEnumEntry(parentClassId, symbolProvider)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)parentClassId.getShortClassName(), (DiagnosticContext)context2, null, 16, null);
                return;
            }
            int errorSegmentIndexFromLast = firResolvedImport.isAllUnder() ? 0 : 1;
            ClassId currentClassId = parentClassId.getParentClassId();
            while (currentClassId != null && symbolProvider.getClassLikeSymbolByClassId(currentClassId) == null) {
                currentClassId = currentClassId.getParentClassId();
                ++errorSegmentIndexFromLast;
            }
            KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getSourceForImportSegment(firResolvedImport, errorSegmentIndexFromLast);
            if (ktSourceElement2 == null) {
                return;
            }
            KtSourceElement unresolvedSource = ktSourceElement2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedSource, FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)this.getOutermostClassName(parentClassId), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final String getOutermostClassName(ClassId $this$getOutermostClassName) {
        List<Name> list2 = $this$getOutermostClassName.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "pathSegments(...)");
        String string2 = CollectionsKt.first(list2).asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return string2;
    }

    private final boolean isClassIdPointingToEnumEntry(ClassId classId, FirSymbolProvider symbolProvider) {
        boolean bl;
        block8: {
            Object object;
            block10: {
                block9: {
                    ClassId classId2 = classId.getParentClassId();
                    if (classId2 == null) {
                        return false;
                    }
                    ClassId enumClassId = classId2;
                    FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(enumClassId);
                    object = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (object == null) break block9;
                    Object object2 = object;
                    FirRegularClassSymbol it = object2;
                    boolean bl2 = false;
                    FirClassSymbol $this$isEnumClass$iv = it;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    object = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? object2 : null;
                    if (object != null) break block10;
                }
                return false;
            }
            FirRegularClassSymbol enumClass2 = object;
            Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(enumClass2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getCallableId().getCallableName(), classId.getShortClassName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }
}

