/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterList;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirFunctionTypeParametersSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/psi/KtFunction;", "()V", "checkLightTree", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtLightSourceElement;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsi", "Lksp/org/jetbrains/kotlin/KtPsiSourceElement;", "psi", "isApplicable", "", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirFunctionTypeParametersSyntaxChecker
extends FirDeclarationSyntaxChecker<FirSimpleFunction, KtFunction> {
    @NotNull
    public static final FirFunctionTypeParametersSyntaxChecker INSTANCE = new FirFunctionTypeParametersSyntaxChecker();

    private FirFunctionTypeParametersSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirSimpleFunction element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return !(source.getKind() instanceof KtFakeSourceElementKind);
    }

    @Override
    public void checkPsi(@NotNull FirSimpleFunction element2, @NotNull KtPsiSourceElement source, @NotNull KtFunction psi2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi2, "psi");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtTypeParameterList typeParamsNode = psi2.getTypeParameterList();
        PsiElement nameNode = psi2.getNameIdentifier();
        if (typeParamsNode != null && nameNode != null && PsiUtilsKt.getStartOffset(typeParamsNode) > PsiUtilsKt.getStartOffset(nameNode)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_TYPE_PARAMETER_SYNTAX(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirSimpleFunction element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        LighterASTNode typeParamsNode = LightTreePositioningStrategiesKt.typeParametersList(source.getTreeStructure(), source.getLighterASTNode());
        LighterASTNode nameNode = LightTreePositioningStrategiesKt.nameIdentifier(source.getTreeStructure(), source.getLighterASTNode());
        if (typeParamsNode != null && nameNode != null && typeParamsNode.getStartOffset() > nameNode.getStartOffset()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_TYPE_PARAMETER_SYNTAX(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

