/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "analyze", "", "data", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "ReassignedVariableCollector", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1#2:66\n1772#3,4:67\n1787#3,3:71\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n*L\n32#1:67,4\n36#1:71,3\n*E\n"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();

    private CanBeValChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull PropertyInitializationInfoData data2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Iterator<FirPropertySymbol> iterator2;
        ReassignedVariableCollector reassignedVariableCollector;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context2, "context");
        ReassignedVariableCollector $this$analyze_u24lambda_u240 = reassignedVariableCollector = new ReassignedVariableCollector(data2);
        boolean bl = false;
        data2.getGraph().traverse($this$analyze_u24lambda_u240);
        ReassignedVariableCollector collector2 = reassignedVariableCollector;
        Iterator<FirPropertySymbol> iterator3 = iterator2 = data2.getProperties().iterator();
        while (iterator3.hasNext()) {
            boolean canBeVal;
            boolean bl2;
            KtSourceElement source;
            FirPropertySymbol symbol2 = iterator3.next();
            if (symbol2.getSource() == null) continue;
            if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                void $this$fold$iv;
                int n;
                Iterable $this$count$iv = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count = n;
                $this$count$iv = RangesKt.until(0, count);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                Iterator iterator4 = $this$fold$iv.iterator();
                while (iterator4.hasNext()) {
                    int element$iv = ((IntIterator)iterator4).nextInt();
                    boolean acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = iterator2.hasNext() && collector2.canBeVal(iterator2.next()) && acc;
                }
                bl2 = accumulator$iv;
            } else {
                bl2 = collector2.canBeVal(symbol2);
            }
            if (!(canBeVal = bl2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCAN_BE_VAL(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector;", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;)V", "getData", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reassigned", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "canBeVal", "", "symbol", "visitNode", "", "node", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableAssignmentNode", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1745#2,3:66\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n*L\n55#1:66,3\n*E\n"})
    private static final class ReassignedVariableCollector
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final PropertyInitializationInfoData data;
        @NotNull
        private final Set<FirPropertySymbol> reassigned;

        public ReassignedVariableCollector(@NotNull PropertyInitializationInfoData data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            this.data = data2;
            this.reassigned = new LinkedHashSet();
        }

        @NotNull
        public final PropertyInitializationInfoData getData() {
            return this.data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            block9: {
                Object symbol2;
                block10: {
                    boolean bl;
                    block8: {
                        boolean isForInitialization;
                        Intrinsics.checkNotNullParameter(node, "node");
                        Object object = FirExpressionUtilKt.getCalleeReference(node.getFir());
                        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                            return;
                        }
                        symbol2 = object;
                        if (!((FirPropertySymbol)symbol2).isVar()) break block9;
                        KtSourceElement ktSourceElement = ((FirBasedSymbol)symbol2).getSource();
                        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind || !this.data.getProperties().contains(symbol2)) break block9;
                        boolean bl2 = isForInitialization = this.data.getGraph().getKind() == ControlFlowGraph.Kind.Class || this.data.getGraph().getKind() == ControlFlowGraph.Kind.File;
                        if (!FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol2, isForInitialization)) break block10;
                        Iterable $this$any$iv = this.data.getValue(node).values();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PropertyInitializationInfo it = (PropertyInitializationInfo)element$iv;
                                boolean bl3 = false;
                                EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)it.get(symbol2));
                                boolean bl4 = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(eventOccurrencesRange) : false;
                                if (!bl4) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block9;
                }
                this.reassigned.add((FirPropertySymbol)symbol2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canBeVal(@NotNull FirPropertySymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            if (!symbol2.isVar()) return false;
            if (symbol2.getHasDelegate()) return false;
            KtSourceElement ktSourceElement = symbol2.getSource();
            if (ktSourceElement == null) return false;
            KtSourceElementKind ktSourceElementKind = ktSourceElement.getKind();
            if (ktSourceElementKind == null) {
                return false;
            }
            boolean bl = ktSourceElementKind instanceof KtFakeSourceElementKind;
            if (bl) return false;
            if (this.reassigned.contains(symbol2)) return false;
            return true;
        }
    }
}

