/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElementKt;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,61:1\n533#2,6:62\n35#3:68\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n46#1:62,6\n53#1:68\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context2)) {
            return;
        }
        Object object = FirExpressionUtilKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment) {
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, true, null), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context2, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u241, experimentalities, ((FirVariableAssignment)expression2).getLValue(), context2, reporter, null, 16, null);
        } else if (expression2 instanceof FirQualifiedAccessExpression) {
            Object object2;
            Object object3 = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            ConeKotlinType dispatchReceiverType = object3 != null && (object3 = FirTypeUtilsKt.getResolvedType((FirExpression)object3)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object3, context2.getSession()) : null;
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context2, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            KtSourceElement ktSourceElement2 = expression2.getSource();
            if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                FirDeclaration firDeclaration;
                block14: {
                    List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        FirDeclaration element$iv;
                        FirDeclaration it = element$iv = iterator$iv.previous();
                        boolean bl2 = false;
                        if (!(it instanceof FirProperty)) continue;
                        firDeclaration = element$iv;
                        break block14;
                    }
                    firDeclaration = null;
                }
                FirDeclaration firDeclaration2 = firDeclaration;
                FirProperty firProperty = firDeclaration2 instanceof FirProperty ? (FirProperty)firDeclaration2 : null;
                if (firProperty == null) {
                    return;
                }
                FirProperty property = firProperty;
                object2 = property.getDelegate();
                if (object2 == null || (object2 = ((FirExpression)object2).getSource()) == null || (object2 = KtSourceElementKt.fakeElement$default((KtSourceElement)object2, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                    return;
                }
            } else {
                object2 = expression2.getSource();
            }
            KtSourceElement source = object2;
            $this$check_u24lambda_u241.reportNotAcceptedExperimentalities((Collection<FirOptInUsageBaseChecker.Experimentality>)experimentalities, expression2, context2, reporter, source);
        } else if (expression2 instanceof FirDelegatedConstructorCall && resolvedSymbol instanceof FirConstructorSymbol) {
            FirCallableSymbol $this$isFromEnumClass$iv = (FirCallableSymbol)resolvedSymbol;
            boolean $i$f$isFromEnumClass = false;
            if ($this$isFromEnumClass$iv.getRawStatus().isFromEnumClass()) {
                Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, null);
                FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u241, experimentalities, ((FirDelegatedConstructorCall)expression2).getCalleeReference(), context2, reporter, null, 16, null);
            }
        }
    }
}

