/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker;", "", "()V", "checkSuperTypes", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "classifierType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "ForDeclarations", "ForQualifiedAccessExpressions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencySupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,104:1\n26#2:105\n26#2:106\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n*L\n95#1:105\n96#1:106\n*E\n"})
public final class FirMissingDependencySupertypeChecker {
    @NotNull
    public static final FirMissingDependencySupertypeChecker INSTANCE = new FirMissingDependencySupertypeChecker();

    private FirMissingDependencySupertypeChecker() {
    }

    public final boolean checkSuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConeKotlinType coneKotlinType = classifierType;
        return this.checkSuperTypes((FirBasedSymbol)(coneKotlinType != null ? ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter, context2);
    }

    public final boolean checkSuperTypes(@Nullable FirBasedSymbol<?> declaration2, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(declaration2 instanceof FirClassSymbol)) {
            return false;
        }
        Set<ConeKotlinType> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context2.getSession()).getMissingSuperTypes((FirClassSymbol)declaration2);
        for (ConeKotlinType superType2 : missingSuperTypes) {
            boolean $i$f$emptyArray = false;
            $i$f$emptyArray = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), (Object)ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt.withArguments(superType2, new ConeTypeProjection[0]), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration2, new ConeTypeProjection[0], false, null, 4, null), (DiagnosticContext)context2, null, 32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForDeclarations;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForDeclarations
    extends FirDeclarationChecker<FirDeclaration> {
        @NotNull
        public static final ForDeclarations INSTANCE = new ForDeclarations();

        private ForDeclarations() {
        }

        @Override
        public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (declaration2 instanceof FirClass) {
                INSTANCE.checkSuperTypes((FirBasedSymbol)((FirClass)declaration2).getSymbol(), declaration2.getSource(), reporter, context2);
            }
            if (declaration2 instanceof FirTypeParameterRefsOwner) {
                for (FirTypeParameterRef typeParameter : ((FirTypeParameterRefsOwner)((Object)declaration2)).getTypeParameters()) {
                    for (ConeClassLikeType upperBound : TypeUtilsKt.collectUpperBounds(FirNestedClassifierScopeKt.toConeType(typeParameter))) {
                        INSTANCE.checkSuperTypes(upperBound, typeParameter.getSource(), reporter, context2);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForQualifiedAccessExpressions;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForQualifiedAccessExpressions
    extends FirExpressionChecker<FirQualifiedAccessExpression> {
        @NotNull
        public static final ForQualifiedAccessExpressions INSTANCE = new ForQualifiedAccessExpressions();

        private ForQualifiedAccessExpressions() {
        }

        @Override
        public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean unresolvedLazySupertypesByDefault;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            KtSourceElement source = expression2.getSource();
            FirCallableSymbol symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (symbol2 == null) {
                ConeSimpleKotlinType coneSimpleKotlinType;
                ConeSimpleKotlinType coneSimpleKotlinType2;
                ConeKotlinType coneKotlinType;
                FirExpression firExpression2 = expression2.getExplicitReceiver();
                ConeSimpleKotlinType receiverType2 = firExpression2 != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression2)) != null && (coneSimpleKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType)) != null && (coneSimpleKotlinType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(coneSimpleKotlinType2)) != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, context2.getSession()) : null;
                INSTANCE.checkSuperTypes(receiverType2, source, reporter, context2);
                return;
            }
            boolean missingSupertype = INSTANCE.checkSuperTypes(symbol2.getDispatchReceiverType(), source, reporter, context2);
            boolean eagerChecksAllowed = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
            boolean bl = unresolvedLazySupertypesByDefault = symbol2 instanceof FirConstructorSymbol || symbol2 instanceof FirAnonymousFunctionSymbol;
            if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !missingSupertype) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
                INSTANCE.checkSuperTypes((FirBasedSymbol)(coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null), source, reporter, context2);
                FirResolvedTypeRef firResolvedTypeRef = symbol2.getResolvedReceiverTypeRef();
                INSTANCE.checkSuperTypes(firResolvedTypeRef != null ? FirTypeUtilsKt.getConeTypeOrNull(firResolvedTypeRef) : null, source, reporter, context2);
            }
        }
    }
}

