/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import ksp.org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeContractShouldBeFirstStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirContractNotFirstStatementChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "isNonFirstStatement", "", "Lksp/org/jetbrains/kotlin/fir/contracts/FirContractDescription;", "(Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;)Z", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCorrectlyPlacedIn", "functionDeclaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "checkers"})
public final class FirContractNotFirstStatementChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirContractNotFirstStatementChecker INSTANCE = new FirContractNotFirstStatementChecker();

    private FirContractNotFirstStatementChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
        if (!Intrinsics.areEqual(StandardClassIds.Callables.INSTANCE.getContract(), firCallableSymbol != null ? firCallableSymbol.getCallableId() : null)) {
            return;
        }
        FirDeclaration containingDeclaration2 = CollectionsKt.last(context2.getContainingDeclarations());
        if (!(containingDeclaration2 instanceof FirFunction) || !this.isCorrectlyPlacedIn(expression2, (FirFunction)containingDeclaration2)) {
            String message2 = containingDeclaration2 instanceof FirFunction && ((FirFunction)containingDeclaration2).getBody() instanceof FirSingleExpressionBlock ? "Contracts are only allowed in function body blocks." : "Contract should be the first statement.";
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isCorrectlyPlacedIn(FirFunctionCall $this$isCorrectlyPlacedIn, FirFunction functionDeclaration) {
        Object object = functionDeclaration.getBody();
        FirStatement firstStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.first(object) : null;
        return firstStatement instanceof FirContractCallBlock && Intrinsics.areEqual(((FirContractCallBlock)firstStatement).getCall(), $this$isCorrectlyPlacedIn) && (!(functionDeclaration instanceof FirContractDescriptionOwner) || !this.isNonFirstStatement(((FirContractDescriptionOwner)((Object)functionDeclaration)).getContractDescription()));
    }

    private final boolean isNonFirstStatement(FirContractDescription $this$isNonFirstStatement) {
        return $this$isNonFirstStatement instanceof FirResolvedContractDescription && Intrinsics.areEqual(((FirResolvedContractDescription)$this$isNonFirstStatement).getDiagnostic(), ConeContractShouldBeFirstStatement.INSTANCE);
    }
}

