/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkGlobalDeclaration", "checkLocalDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSealedSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,86:1\n58#2:87\n48#2:88\n40#2:89\n*S KotlinDebug\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n*L\n47#1:87\n56#1:88\n72#1:89\n*E\n"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (FirDeclarationUtilKt.getClassId(declaration2).isLocal()) {
            this.checkLocalDeclaration(declaration2, context2, reporter);
        } else {
            this.checkGlobalDeclaration(declaration2, context2, reporter);
        }
    }

    private final void checkGlobalDeclaration(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FqName subclassPackage = FirDeclarationUtilKt.getClassId(declaration2).getPackageFqName();
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            FirRegularClassSymbol superClass;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId superClassId;
            if (FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(superTypeRef), context2.getSession()) == null || superClassId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(superClassId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClass = superClass;
            FirClassLikeSymbol $this$isSealed$iv = superClass;
            boolean $i$f$isSealed = false;
            if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) continue;
            if (superClass.getOrigin() instanceof FirDeclarationOrigin.Java) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_INHERITS_JAVA_SEALED_CLASS(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            FqName superClassPackage = superClass.getClassId().getPackageFqName();
            if (!Intrinsics.areEqual(superClassPackage, subclassPackage)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_PACKAGE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (Intrinsics.areEqual(superClass.getModuleData(), declaration2.getModuleData())) continue;
            FirClassLikeSymbol $this$isExpect$iv = superClass;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getRawStatus().isExpect()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_MODULE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkLocalDeclaration(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration2.getSuperTypeRefs()) {
            FirRegularClassSymbol superClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId classId;
            if (FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it), context2.getSession()) == null || classId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(classId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClassSymbol = superClassSymbol;
            FirClassLikeSymbol $this$modality$iv = superClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.SEALED) continue;
            String declarationType = declaration2 instanceof FirAnonymousObject ? "Anonymous object" : "Local class";
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), (Object)declarationType, (Object)superClassSymbol.getClassKind(), (DiagnosticContext)context2, null, 32, null);
            return;
        }
    }
}

