/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.CheckResult;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.OperatorFunctionChecks;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.FqNamesUtilKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkReplaceableLegacyOperators", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOperatorModifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOperatorModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,61:1\n41#2:62\n*S KotlinDebug\n*F\n+ 1 FirOperatorModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker\n*L\n27#1:62\n*E\n"})
public final class FirOperatorModifierChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirOperatorModifierChecker INSTANCE = new FirOperatorModifierChecker();

    private FirOperatorModifierChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isOperator$iv = declaration2;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getStatus().isOperator()) {
            return;
        }
        FirElement firElement = declaration2;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPERATOR_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            return;
        }
        CheckResult checkResult = OperatorFunctionChecks.INSTANCE.isOperator(declaration2, context2.getSession(), context2.getScopeSession());
        if (!Intrinsics.areEqual(checkResult, CheckResult.SuccessCheck.INSTANCE)) {
            if (Intrinsics.areEqual(checkResult, CheckResult.IllegalFunctionName.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"illegal function name", (DiagnosticContext)context2, null, 16, null);
                return;
            }
            if (checkResult instanceof CheckResult.IllegalSignature) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)((CheckResult.IllegalSignature)checkResult).getError(), (DiagnosticContext)context2, null, 16, null);
                return;
            }
        }
        this.checkReplaceableLegacyOperators(declaration2, context2, reporter);
    }

    private final void checkReplaceableLegacyOperators(FirSimpleFunction declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Name name2 = OperatorNameConventions.MOD_OPERATORS_REPLACEMENT.get(declaration2.getName());
        if (name2 == null) {
            return;
        }
        Name replacement = name2;
        KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = FqNamesUtilKt.isSubpackageOf(declaration2.getSymbol().getCallableId().getPackageName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitOperatorMod) ? FirErrors.INSTANCE.getDEPRECATED_BINARY_MOD() : FirErrors.INSTANCE.getFORBIDDEN_BINARY_MOD();
        AbstractKtSourceElement abstractKtSourceElement = declaration2.getSource();
        FirNamedFunctionSymbol firNamedFunctionSymbol = declaration2.getSymbol();
        String string2 = replacement.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, diagnostic, (Object)firNamedFunctionSymbol, (Object)string2, (DiagnosticContext)context2, null, 32, null);
    }
}

