/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirPlatformDiagnosticSuppressor;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNonMemberFunctionsCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonMemberFunctionsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNonMemberFunctionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNonMemberFunctionsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonMemberFunctionsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,45:1\n45#2:46\n70#2:47\n37#2:48\n*S KotlinDebug\n*F\n+ 1 FirNonMemberFunctionsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonMemberFunctionsChecker\n*L\n36#1:46\n37#1:47\n38#1:48\n*E\n"})
public final class FirNonMemberFunctionsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirNonMemberFunctionsChecker INSTANCE = new FirNonMemberFunctionsChecker();

    private FirNonMemberFunctionsChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (ClassMembersKt.containingClassLookupTag(declaration2) != null || declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        FirElement firElement = declaration2;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "ABSTRACT_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            return;
        }
        FirMemberDeclaration $this$isExternal$iv = declaration2;
        boolean $i$f$isExternal = false;
        if ($this$isExternal$iv.getStatus().isExternal()) {
            return;
        }
        FirFunction $this$hasBody$iv = declaration2;
        boolean $i$f$getHasBody = false;
        if (!($this$hasBody$iv.getBody() != null)) {
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                FirPlatformDiagnosticSuppressor firPlatformDiagnosticSuppressor = FirNonMemberFunctionsCheckerKt.getPlatformDiagnosticSuppressor(context2.getSession());
                if (!(firPlatformDiagnosticSuppressor != null ? !firPlatformDiagnosticSuppressor.shouldReportNoBody(declaration2, context2) : false)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_MEMBER_FUNCTION_NO_BODY(), declaration2.getSymbol(), (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }
}

