/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import ksp.org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import ksp.org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import ksp.org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "EMPTY_CONTRACT_MESSAGE", "", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkContractNotAllowed", "contractDescription", "Lksp/org/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkUnresolvedEffects", "DiagnosticExtractor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,146:1\n12#2,2:147\n40#2:149\n41#2:150\n21#2:151\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n66#1:147,2\n66#1:149\n67#1:150\n68#1:151\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";

    private FirContractChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)declaration2)).getContractDescription();
        FirResolvedContractDescription firResolvedContractDescription = firContractDescription instanceof FirResolvedContractDescription ? (FirResolvedContractDescription)firContractDescription : null;
        if (firResolvedContractDescription == null) {
            return;
        }
        FirResolvedContractDescription contractDescription = firResolvedContractDescription;
        this.checkUnresolvedEffects(contractDescription, context2, reporter);
        this.checkContractNotAllowed(declaration2, contractDescription, context2, reporter);
        if (contractDescription.getEffects().isEmpty() && contractDescription.getUnresolvedEffects().isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)contractDescription.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic diagnostic;
            if ((ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkContractNotAllowed(FirFunction declaration2, FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        block5: {
            KtSourceElement source;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                                    return;
                                }
                                if (!(declaration2 instanceof FirPropertyAccessor) && !(declaration2 instanceof FirAnonymousFunction)) break block4;
                                FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are only allowed for functions.");
                                break block5;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration2;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block6;
                            FirMemberDeclaration $this$isOpen$iv = declaration2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block6;
                            FirMemberDeclaration $this$isOverride$iv = declaration2;
                            boolean $i$f$isOverride = false;
                            if (!$this$isOverride$iv.getStatus().isOverride()) break block7;
                        }
                        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for open or override functions.");
                        break block5;
                    }
                    FirMemberDeclaration $this$isOperator$iv = declaration2;
                    boolean $i$f$isOperator = false;
                    if (!$this$isOperator$iv.getStatus().isOperator()) break block8;
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for operator functions.");
                    break block5;
                }
                if (declaration2.getSymbol().getCallableId().isLocal()) break block9;
                FirMemberDeclaration $this$visibility$iv = declaration2;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) break block5;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for local functions.");
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message2) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message2, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\bj\u0002`\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\rj\u0002`\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0011j\u0002`\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001a2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u001b\u001a\u00020\u00022\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001d2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u001e\u001a\u00020\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020 2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010!\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\"j\u0002`#2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010$\u001a\u0004\u0018\u00010\u00022\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020&j\u0002`'2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010(\u001a\u0004\u0018\u00010\u00022\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020*j\u0002`+2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010,\u001a\u0004\u0018\u00010\u00022\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020.j\u0002`/2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J,\u00100\u001a\u0004\u0018\u00010\u00022\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000202j\u0002`32\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u00064"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "()V", "visitCallsEffectDeclaration", "callsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitContractDescriptionElement", "contractDescriptionElement", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "visitErroneousCallsEffectDeclaration", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitErroneousConstantReference", "erroneousConstantReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousElement", "element", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "visitErroneousIsInstancePredicate", "isInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitErroneousValueParameterReference", "valueParameterReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitIsInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lksp/org/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lksp/org/jetbrains/kotlin/contracts/description/KtLogicalNot;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitReturnsEffectDeclaration", "returnsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, "contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(conditionalEffect, "conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(returnsEffect, "returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(callsEffect, "callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(callsEffect, "callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, "binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, "erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(valueParameterReference, "valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element2, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            return element2.getDiagnostic();
        }
    }
}

