/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.DeclaredVariableCollector;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.util.MultimapKt;
import ksp.org.jetbrains.kotlin.fir.util.SetMultimap;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000*\u0001\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;", "", "()V", "declaredVariablesPerElement", "Lksp/org/jetbrains/kotlin/fir/util/SetMultimap;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getDeclaredVariablesPerElement", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "visitor", "ksp/org/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1;", "enterCapturingStatement", "", "statement", "exitCapturingStatement", "", "checkers"})
public final class DeclaredVariableCollector {
    @NotNull
    private final SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesPerElement = MultimapKt.setMultimapOf();
    @NotNull
    private final visitor.1 visitor = new FirVisitor<Unit, FirStatement>(this){
        final /* synthetic */ DeclaredVariableCollector this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitElement(FirElement element2, FirStatement data2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            element2.acceptChildren(this, data2);
        }

        public void visitProperty(FirProperty property, FirStatement data2) {
            Intrinsics.checkNotNullParameter(property, "property");
            if (property.isLocal()) {
                if (data2 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                this.this$0.getDeclaredVariablesPerElement().put(data2, property.getSymbol());
            }
            this.visitElement((FirElement)property, data2);
        }

        public void visitWhileLoop(FirWhileLoop whileLoop, FirStatement data2) {
            Intrinsics.checkNotNullParameter(whileLoop, "whileLoop");
            this.visitCapturingStatement(whileLoop, data2);
        }

        public void visitDoWhileLoop(FirDoWhileLoop doWhileLoop, FirStatement data2) {
            Intrinsics.checkNotNullParameter(doWhileLoop, "doWhileLoop");
            this.visitCapturingStatement(doWhileLoop, data2);
        }

        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, FirStatement data2) {
            Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            this.visitCapturingStatement(anonymousFunction, data2);
        }

        public void visitSimpleFunction(FirSimpleFunction simpleFunction, FirStatement data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            this.visitCapturingStatement(simpleFunction, data2);
        }

        public void visitRegularClass(FirRegularClass regularClass, FirStatement data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            this.visitCapturingStatement(regularClass, data2);
        }

        public void visitAnonymousObject(FirAnonymousObject anonymousObject, FirStatement data2) {
            Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
            this.visitCapturingStatement(anonymousObject, data2);
        }

        private final void visitCapturingStatement(FirStatement statement2, FirStatement parent2) {
            this.visitElement((FirElement)statement2, statement2);
            if (parent2 != null) {
                this.this$0.getDeclaredVariablesPerElement().putAll(parent2, (Collection<FirPropertySymbol>)this.this$0.getDeclaredVariablesPerElement().get(statement2));
            }
        }
    };

    @NotNull
    public final SetMultimap<FirStatement, FirPropertySymbol> getDeclaredVariablesPerElement() {
        return this.declaredVariablesPerElement;
    }

    @NotNull
    public final Set<FirPropertySymbol> enterCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statement2, "statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.declaredVariablesPerElement.contains(statement2)) {
            statement2.accept(this.visitor, null);
        }
        return (Set)this.declaredVariablesPerElement.get(statement2);
    }

    public final void exitCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statement2, "statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.declaredVariablesPerElement.removeKey(statement2);
    }
}

