/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.contracts.model.visitors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.contracts.model.Computation;
import ksp.org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import ksp.org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import ksp.org.jetbrains.kotlin.contracts.model.ESValue;
import ksp.org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESBooleanType;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESIs;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESNot;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESOr;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import ksp.org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/contracts/model/visitors/Substitutor;", "Lksp/org/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lksp/org/jetbrains/kotlin/contracts/model/Computation;", "substitutions", "", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESVariable;", "typeSubstitution", "Lksp/org/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lksp/org/jetbrains/kotlin/contracts/model/visitors/Reducer;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)V", "visitAnd", "and", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "esConstant", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitEqual", "equal", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitLambda", "lambda", "Lksp/org/jetbrains/kotlin/contracts/model/ESValue;", "visitNot", "not", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitReceiver", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitVariable", "esVariable", "resolution"})
public final class Substitutor
implements ESExpressionVisitor<Computation> {
    @NotNull
    private final Map<ESVariable, Computation> substitutions;
    @NotNull
    private final ESTypeSubstitution typeSubstitution;
    @NotNull
    private final Reducer reducer;

    public Substitutor(@NotNull Map<ESVariable, ? extends Computation> substitutions, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        Intrinsics.checkNotNullParameter(substitutions, "substitutions");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        this.substitutions = substitutions;
        this.typeSubstitution = typeSubstitution;
        this.reducer = reducer;
    }

    @Override
    @Nullable
    public Computation visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkNotNullParameter(isOperator, "isOperator");
        Computation computation = (Computation)isOperator.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, isOperator.getFunctor().invokeWithArguments(arg, this.typeSubstitution));
    }

    @Override
    @Nullable
    public Computation visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter(not, "not");
        Computation computation = (Computation)not.getArg().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, not.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter(equal, "equal");
        Computation computation = (Computation)equal.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)equal.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        Computation[] computationArray = new Computation[]{left, right};
        return new CallComputation(ESBooleanType.INSTANCE, equal.getFunctor().invokeWithArguments(CollectionsKt.listOf(computationArray), this.typeSubstitution, this.reducer));
    }

    @Override
    @Nullable
    public Computation visitAnd(@NotNull ESAnd and2) {
        Intrinsics.checkNotNullParameter(and2, "and");
        Computation computation = (Computation)and2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)and2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, and2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitOr(@NotNull ESOr or2) {
        Intrinsics.checkNotNullParameter(or2, "or");
        Computation computation = (Computation)or2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)or2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, or2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @NotNull
    public Computation visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter(esVariable, "esVariable");
        Computation computation = this.substitutions.get(esVariable);
        if (computation == null) {
            computation = esVariable;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter(esConstant, "esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter(esReceiver, "esReceiver");
        return esReceiver;
    }

    @Override
    @NotNull
    public Computation visitLambda(@NotNull ESValue lambda2) {
        Intrinsics.checkNotNullParameter(lambda2, "lambda");
        return lambda2;
    }
}

