/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.range;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.codegen.ExpressionCodegen;
import ksp.org.jetbrains.kotlin.codegen.range.ReversableRangeValue;
import ksp.org.jetbrains.kotlin.codegen.range.comparison.ComparisonGeneratorKt;
import ksp.org.jetbrains.kotlin.codegen.range.forLoop.ForInRangeInstanceLoopGenerator;
import ksp.org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator;
import ksp.org.jetbrains.kotlin.codegen.range.inExpression.CallBasedInExpressionGenerator;
import ksp.org.jetbrains.kotlin.codegen.range.inExpression.InExpressionGenerator;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtForExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.RangeUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/codegen/range/PrimitiveRangeRangeValue;", "Lksp/org/jetbrains/kotlin/codegen/range/ReversableRangeValue;", "rangeExpression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "createForInReversedLoopGenerator", "Lksp/org/jetbrains/kotlin/codegen/range/forLoop/ForLoopGenerator;", "codegen", "Lksp/org/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lksp/org/jetbrains/kotlin/psi/KtForExpression;", "createForLoopGenerator", "Lksp/org/jetbrains/kotlin/codegen/range/forLoop/ForInRangeInstanceLoopGenerator;", "createInExpressionGenerator", "Lksp/org/jetbrains/kotlin/codegen/range/inExpression/InExpressionGenerator;", "operatorReference", "Lksp/org/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getRangeElementType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "backend"})
public final class PrimitiveRangeRangeValue
implements ReversableRangeValue {
    @NotNull
    private final KtExpression rangeExpression;

    public PrimitiveRangeRangeValue(@NotNull KtExpression rangeExpression) {
        Intrinsics.checkNotNullParameter(rangeExpression, "rangeExpression");
        this.rangeExpression = rangeExpression;
    }

    @Override
    @NotNull
    public ForInRangeInstanceLoopGenerator createForLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(forExpression, "forExpression");
        return new ForInRangeInstanceLoopGenerator(codegen2, forExpression, this.rangeExpression, ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.getRangeElementType(codegen2, forExpression)), false);
    }

    @Override
    @NotNull
    public InExpressionGenerator createInExpressionGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtSimpleNameExpression operatorReference) {
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(operatorReference, "operatorReference");
        return new CallBasedInExpressionGenerator(codegen2, operatorReference);
    }

    @Override
    @NotNull
    public ForLoopGenerator createForInReversedLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(forExpression, "forExpression");
        return new ForInRangeInstanceLoopGenerator(codegen2, forExpression, this.rangeExpression, ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.getRangeElementType(codegen2, forExpression)), true);
    }

    private final KotlinType getRangeElementType(ExpressionCodegen codegen2, KtForExpression forExpression) {
        KtExpression ktExpression = forExpression.getLoopRange();
        if (ktExpression == null) {
            throw new AssertionError((Object)("No loop range expression: " + forExpression.getText()));
        }
        KtExpression ktLoopRange = ktExpression;
        KotlinType kotlinType = codegen2.getBindingContext().getType(ktLoopRange);
        if (kotlinType == null) {
            throw new AssertionError((Object)("No type for loop range expression: " + ktLoopRange.getText()));
        }
        KotlinType rangeType = kotlinType;
        KotlinType kotlinType2 = RangeUtilKt.getRangeOrProgressionElementType$default(rangeType, null, 2, null);
        if (kotlinType2 == null) {
            throw new AssertionError((Object)("Unexpected range type: " + rangeType));
        }
        return kotlinType2;
    }
}

