/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.compiler;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import ksp.org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmCompilerDeserializationConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lksp/org/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lksp/org/jetbrains/kotlin/resolve/jvm/JvmCompilerDeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmCompilerDeserializationConfiguration;", "loadedModules", "", "Lksp/org/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "addRoots", "", "roots", "", "Lksp/org/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lksp/org/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli-base"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final JvmCompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings2, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(scope, "scope");
        this.scope = scope;
        this.deserializationConfiguration = new JvmCompilerDeserializationConfiguration(languageVersionSettings2);
        this.loadedModules = new SmartList();
    }

    @Override
    @NotNull
    public JvmCompilerDeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(roots2, "roots");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile[] virtualFileArray;
            VirtualFile metaInf;
            VirtualFile root = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root) || root.findChild("META-INF") == null) continue;
            Intrinsics.checkNotNullExpressionValue(metaInf.getChildren(), "getChildren(...)");
            for (VirtualFile moduleFile : virtualFileArray) {
                String string2 = moduleFile.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                if (!StringsKt.endsWith$default(string2, "kotlin_module", false, 2, null)) continue;
                Function0 function0 = new Function0<byte[]>(moduleFile){
                    final /* synthetic */ VirtualFile $moduleFile;
                    {
                        this.$moduleFile = $moduleFile;
                        super(0);
                    }

                    public final byte[] invoke() {
                        byte[] byArray = this.$moduleFile.contentsToByteArray();
                        Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
                        return byArray;
                    }
                };
                String string3 = moduleFile.toString();
                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                String string4 = moduleFile.getPath();
                Intrinsics.checkNotNullExpressionValue(string4, "getPath(...)");
                ModuleMapping moduleMapping = JvmPackagePartProviderKt.tryLoadModuleMapping(function0, string3, string4, this.getDeserializationConfiguration(), messageCollector);
                if (moduleMapping == null) continue;
                ModuleMapping it = moduleMapping;
                boolean bl = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list2 = this.getLoadedModules();
                String string5 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string5, "getNameWithoutExtension(...)");
                list2.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root, it, string5));
            }
        }
    }
}

