/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenCondition;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenEntry;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/cfg/WhenOnNullableExhaustivenessChecker;", "", "()V", "getMissingCases", "", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "nullable", "", "getNullCaseIfMissing", "frontend"})
final class WhenOnNullableExhaustivenessChecker {
    @NotNull
    public static final WhenOnNullableExhaustivenessChecker INSTANCE = new WhenOnNullableExhaustivenessChecker();

    private WhenOnNullableExhaustivenessChecker() {
    }

    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, boolean nullable) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        return nullable ? this.getNullCaseIfMissing(expression2, context2) : CollectionsKt.emptyList();
    }

    private final List<WhenMissingCase> getNullCaseIfMissing(KtWhenExpression expression2, BindingContext context2) {
        for (KtWhenEntry entry : expression2.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            Intrinsics.checkNotNullExpressionValue(entry.getConditions(), "getConditions(...)");
            for (KtWhenCondition condition : ktWhenConditionArray) {
                KtExpression it;
                if (!(condition instanceof KtWhenConditionWithExpression)) continue;
                if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                boolean bl = false;
                KotlinType type2 = context2.getType(it);
                if (type2 == null || !KotlinBuiltIns.isNullableNothing(type2)) continue;
                return CollectionsKt.emptyList();
            }
        }
        return CollectionsKt.listOf(WhenMissingCase.NullIsMissing.INSTANCE);
    }
}

