/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/UpdateConstantFacadePropertyReferences;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "shouldGeneratePartHierarchy", "", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "getReplacementFacadeClassOrNull", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "lower", "", "backend.jvm.lower"})
final class UpdateConstantFacadePropertyReferences
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private final boolean shouldGeneratePartHierarchy;

    public UpdateConstantFacadePropertyReferences(@NotNull JvmBackendContext context2, boolean shouldGeneratePartHierarchy) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.shouldGeneratePartHierarchy = shouldGeneratePartHierarchy;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        IrClass irClass2 = this.getReplacementFacadeClassOrNull(irClass);
        if (irClass2 == null) {
            return;
        }
        IrClass facadeClass = irClass2;
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, new IrElementTransformerVoid(facadeClass){
            final /* synthetic */ IrClass $facadeClass;
            {
                this.$facadeClass = $facadeClass;
            }

            public IrStatement visitClass(IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return declaration2;
            }

            public IrExpression visitClassReference(IrClassReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return new IrClassReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(this.$facadeClass), this.$facadeClass.getSymbol(), IrUtilsKt.getDefaultType(this.$facadeClass));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getReplacementFacadeClassOrNull(IrClass irClass) {
        IrElement irElement;
        if (!Intrinsics.areEqual(irClass.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_PROPERTY_REFERENCE()) && !Intrinsics.areEqual(irClass.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
            return null;
        }
        IrAttributeContainer callableReference2 = irClass.getAttributeOwnerId();
        if (callableReference2 instanceof IrPropertyReference) {
            Object object = ((IrPropertyReference)callableReference2).getGetter();
            irElement = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
        } else {
            if (!(callableReference2 instanceof IrFunctionReference)) return null;
            irElement = ((IrFunctionSymbol)((IrFunctionReference)callableReference2).getSymbol()).getOwner();
        }
        if (irElement == null) {
            return null;
        }
        IrElement declaration2 = irElement;
        IrDeclarationParent irDeclarationParent = ((IrDeclarationBase)declaration2).getParent();
        if (!(irDeclarationParent instanceof IrClass)) return null;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        if (irClass2 == null) {
            return null;
        }
        IrClass parent2 = irClass2;
        IrClass facadeClass = this.context.getMultifileFacadeClassForPart().get(parent2.getAttributeOwnerId());
        if (!this.shouldGeneratePartHierarchy) {
            if (!(declaration2 instanceof IrProperty)) return null;
            IrField irField = ((IrProperty)declaration2).getBackingField();
            if (irField == null) return null;
            if (!GenerateMultifileFacadesKt.access$shouldMoveToFacade(irField)) return null;
            boolean bl = true;
            if (!bl) return null;
        }
        IrClass irClass3 = facadeClass;
        return irClass3;
    }
}

