/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.backend.common.lower.VisibilityPolicy;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweringPhasesKt;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/JvmVisibilityPolicy;", "Lksp/org/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "()V", "forCapturedField", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "value", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "forClass", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "inInlineFunctionScope", "", "forConstructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "scopedVisibility", "backend.jvm.lower"})
public final class JvmVisibilityPolicy
implements VisibilityPolicy {
    @Override
    @NotNull
    public DescriptorVisibility forClass(@NotNull IrClass declaration2, boolean inInlineFunctionScope2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return JvmLoweringPhasesKt.isGeneratedLambdaClass(declaration2) ? this.scopedVisibility(inInlineFunctionScope2) : declaration2.getVisibility();
    }

    @Override
    @NotNull
    public DescriptorVisibility forConstructor(@NotNull IrConstructor declaration2, boolean inInlineFunctionScope2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return IrUtilsKt.isAnonymousObject(IrUtilsKt.getParentAsClass(declaration2)) ? this.scopedVisibility(inInlineFunctionScope2) : declaration2.getVisibility();
    }

    @Override
    @NotNull
    public DescriptorVisibility forCapturedField(@NotNull IrValueSymbol value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        DescriptorVisibility descriptorVisibility = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PACKAGE_VISIBILITY");
        return descriptorVisibility;
    }

    private final DescriptorVisibility scopedVisibility(boolean inInlineFunctionScope2) {
        DescriptorVisibility descriptorVisibility;
        if (inInlineFunctionScope2) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility3, "PACKAGE_VISIBILITY");
        }
        return descriptorVisibility;
    }
}

