/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.InitializerCallReplacer;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.JavaLikeCounterLoopBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.NumericForLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader;", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/NumericForLoopHeader;", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;", "headerInfo", "builder", "Lksp/org/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "javaLikeCounterLoopBuilder", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/JavaLikeCounterLoopBuilder;", "loopInitStatements", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "getLoopInitStatements", "()Ljava/util/List;", "preferJavaLikeCounterLoop", "", "buildLoop", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "oldLoop", "Lksp/org/jetbrains/kotlin/ir/expressions/IrLoop;", "newBody", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "initializeIteration", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "loopVariable", "loopVariableComponents", "", "", "backendContext", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIndexedGetLoopHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedGetLoopHeader.kt\norg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class IndexedGetLoopHeader
extends NumericForLoopHeader<IndexedGetHeaderInfo> {
    private final boolean preferJavaLikeCounterLoop;
    @NotNull
    private final JavaLikeCounterLoopBuilder javaLikeCounterLoopBuilder;
    @NotNull
    private final List<IrVariable> loopInitStatements;

    public IndexedGetLoopHeader(@NotNull IndexedGetHeaderInfo headerInfo, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(headerInfo, "headerInfo");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(context2, "context");
        super((NumericHeaderInfo)headerInfo, builder2, context2);
        this.preferJavaLikeCounterLoop = context2.getPreferJavaLikeCounterLoop();
        this.javaLikeCounterLoopBuilder = new JavaLikeCounterLoopBuilder(context2);
        IrVariable[] irVariableArray = new IrVariable[]{headerInfo.getObjectVariable(), this.getInductionVariable(), this.getLastVariableIfCanCacheLast(), this.getStepVariable()};
        this.loopInitStatements = CollectionsKt.listOfNotNull(irVariableArray);
    }

    @NotNull
    public List<IrVariable> getLoopInitStatements() {
        return this.loopInitStatements;
    }

    @Override
    @NotNull
    public List<IrStatement> initializeIteration(@Nullable IrVariable loopVariable, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext backendContext) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter(loopVariableComponents, "loopVariableComponents");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        DeclarationIrBuilder $this$initializeIteration_u24lambda_u242 = builder2;
        boolean bl = false;
        IndexedGetIterationHandler $this$initializeIteration_u24lambda_u242_u24lambda_u240 = ((IndexedGetHeaderInfo)this.getHeaderInfo()).getExpressionHandler();
        boolean bl2 = false;
        IrSimpleFunction indexedGetFun = $this$initializeIteration_u24lambda_u242_u24lambda_u240.getGetFunction(((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable().getType());
        IrCall $this$initializeIteration_u24lambda_u242_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall$default($this$initializeIteration_u24lambda_u242, indexedGetFun.getSymbol(), indexedGetFun.getReturnType(), 0, 0, null, 28, null);
        boolean bl3 = false;
        $this$initializeIteration_u24lambda_u242_u24lambda_u241.setDispatchReceiver(ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u242, ((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable()));
        $this$initializeIteration_u24lambda_u242_u24lambda_u241.putValueArgument(0, ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u242, this.getInductionVariable()));
        IrExpression irExpression = irCall;
        IrAnnotationContainer irAnnotationContainer = loopVariable;
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            irAnnotationContainer = indexedGetFun.getReturnType();
        }
        IrExpression get2 = IrUtilsKt.implicitCastIfNeededTo(irExpression, (IrType)irAnnotationContainer);
        IrVariable irVariable = loopVariable;
        if (irVariable != null) {
            IrExpression irExpression2 = loopVariable.getInitializer();
            irVariable.setInitializer((IrExpression)(irExpression2 != null ? irExpression2.transform((IrElementTransformer)new InitializerCallReplacer(get2), (Object)null) : null));
        }
        IrVariable irVariable2 = loopVariable;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(irVariable2 != null ? (IrElement)irVariable2 : (IrElement)get2), this.incrementInductionVariable($this$initializeIteration_u24lambda_u242));
    }

    @Override
    @NotNull
    public LoopReplacement buildLoop(@NotNull DeclarationIrBuilder builder2, @NotNull IrLoop oldLoop, @Nullable IrExpression newBody) {
        LoopReplacement loopReplacement;
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(oldLoop, "oldLoop");
        DeclarationIrBuilder $this$buildLoop_u24lambda_u244 = builder2;
        boolean bl = false;
        IrExpression newLoopCondition = this.buildLoopCondition($this$buildLoop_u24lambda_u244);
        if (this.preferJavaLikeCounterLoop) {
            loopReplacement = this.javaLikeCounterLoopBuilder.buildJavaLikeDoWhileCounterLoop(oldLoop, newLoopCondition, newBody, null);
        } else {
            IrWhileLoopImpl irWhileLoopImpl;
            IrWhileLoopImpl $this$buildLoop_u24lambda_u244_u24lambda_u243 = irWhileLoopImpl = new IrWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), oldLoop.getOrigin());
            boolean bl2 = false;
            $this$buildLoop_u24lambda_u244_u24lambda_u243.setLabel(oldLoop.getLabel());
            $this$buildLoop_u24lambda_u244_u24lambda_u243.setCondition(newLoopCondition);
            $this$buildLoop_u24lambda_u244_u24lambda_u243.setBody(newBody);
            IrWhileLoopImpl newLoop = irWhileLoopImpl;
            loopReplacement = new LoopReplacement(newLoop, newLoop);
        }
        return loopReplacement;
    }
}

