/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeys;
import ksp.org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import ksp.org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ConstEvaluationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "suppressErrors", "", "configuration", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;ZLorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "evaluatedConstTracker", "Lksp/org/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lksp/org/jetbrains/kotlin/incremental/components/InlineConstTracker;", "interpreter", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "mode", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.common"})
public final class ConstEvaluationLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    private final boolean suppressErrors;
    @NotNull
    private final IrInterpreter interpreter;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final EvaluationMode mode;

    public ConstEvaluationLowering(@NotNull CommonBackendContext context2, boolean suppressErrors, @NotNull IrInterpreterConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        this.context = context2;
        this.suppressErrors = suppressErrors;
        this.interpreter = new IrInterpreter(new IrInterpreterEnvironment(this.context.getIrBuiltIns(), configuration2), MapsKt.emptyMap());
        this.evaluatedConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.EVALUATED_CONST_TRACKER);
        this.inlineConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.INLINE_CONST_TRACKER);
        this.mode = EvaluationMode.ONLY_INTRINSIC_CONST;
    }

    public /* synthetic */ ConstEvaluationLowering(CommonBackendContext commonBackendContext, boolean bl, IrInterpreterConfiguration irInterpreterConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = commonBackendContext.getConfiguration().getBoolean(CommonConfigurationKeys.IGNORE_CONST_OPTIMIZATION_ERRORS);
        }
        if ((n & 4) != 0) {
            irInterpreterConfiguration = new IrInterpreterConfiguration(null, 0, 0, false, true, false, 47, null);
        }
        this(commonBackendContext, bl, irInterpreterConfiguration);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrConstTransformerKt.runConstOptimizations(irFile, this.interpreter, this.mode, this.evaluatedConstTracker, this.inlineConstTracker, this.suppressErrors);
    }
}

