/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.asJava.finder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFinder;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.impl.compiled.ClsClassImpl;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import ksp.org.jetbrains.kotlin.asJava.classes.KtLightClass;
import ksp.org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import ksp.org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.FqNamesUtilKt;
import ksp.org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtEnumEntry;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J&\u0010\u001d\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002JB\u0010\u001e\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010(J#\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020*0-2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u00103\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lksp/org/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lksp/com/intellij/psi/PsiElementFinder;", "Lksp/org/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lksp/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "kotlinAsJavaSupport", "Lksp/org/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "psiManager", "Lksp/com/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findClass", "Lksp/com/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lksp/org/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findPackage", "Lksp/com/intellij/psi/PsiPackage;", "findRepeatableAnnotationContainer", "findSyntheticInnerClass", "syntheticName", "predicate", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "", "getClassNames", "", "psiPackage", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "getPackageFiles", "Lksp/com/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lksp/com/intellij/openapi/util/Condition;", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "sortByPreferenceToSourceFile", "list", "Lksp/com/intellij/util/SmartList;", "searchScope", "Companion", "light-classes-base"})
@SourceDebugExtension(value={"SMAP\nJavaElementFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n37#2,2:192\n37#2,2:198\n37#2,2:200\n37#2,2:204\n1547#3:194\n1618#3,3:195\n1000#3,2:202\n*S KotlinDebug\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder\n*L\n52#1:192,2\n135#1:198,2\n152#1:200,2\n164#1:204,2\n135#1:194\n135#1:195,3\n159#1:202,2\n*E\n"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    public JavaElementFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        PsiManager psiManager2 = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue(psiManager2, "getInstance(...)");
        this.psiManager = psiManager2;
        this.kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(scope, "scope");
        return ArraysKt.firstOrNull(this.findClasses(qualifiedName2, scope));
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        Intrinsics.checkNotNullParameter(scope, "scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue(PsiClass.EMPTY_ARRAY, "EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName2 = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName2, scope, (List<PsiClass>)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName2, scope));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName2, scope));
        this.sortByPreferenceToSourceFile(answer, scope);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void findClassesAndObjects(FqName qualifiedName2, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName2, scope, answer);
        this.findRepeatableAnnotationContainer(qualifiedName2, scope, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2, scope);
        for (KtClassOrObject declaration2 : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration2 instanceof KtEnumEntry || (lightClass = this.kotlinAsJavaSupport.getLightClass(declaration2)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName2, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "DefaultImpls", scope, answer, findInterfaceDefaultImpls.1.INSTANCE);
    }

    private final void findRepeatableAnnotationContainer(FqName qualifiedName2, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "Container", scope, answer, findRepeatableAnnotationContainer.1.INSTANCE);
    }

    private final void findSyntheticInnerClass(FqName qualifiedName2, String syntheticName, GlobalSearchScope scope, List<PsiClass> answer, Function1<? super KtClassOrObject, Boolean> predicate) {
        if (qualifiedName2.isRoot() || !Intrinsics.areEqual(qualifiedName2.shortName().asString(), syntheticName)) {
            return;
        }
        FqName fqName2 = qualifiedName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "parent(...)");
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(fqName2, scope)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!predicate.invoke(classOrObject).booleanValue() || this.kotlinAsJavaSupport.getLightClass(classOrObject) == null || interfaceClass.findInnerClassByName(syntheticName, false) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope, "scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = new HashSet<String>();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope));
        for (KtClassOrObject declaration2 : declarations2) {
            String name2;
            if (declaration2.getName() == null) continue;
            answer.add(name2);
        }
        return answer;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.project);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName2, allScope) ? (PsiPackage)new KtLightPackage(this.psiManager, fqName2, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(psiPackage.getQualifiedName()), scope);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtLightPackage(this.psiManager, (FqName)it, scope));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiPackage[0]);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope, "scope");
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (KtClassOrObject declaration2 : declarations2) {
            KtLightClass aClass;
            if (this.kotlinAsJavaSupport.getLightClass(declaration2) == null) continue;
            answer.add(aClass);
        }
        this.sortByPreferenceToSourceFile(answer, scope);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list2, GlobalSearchScope searchScope) {
        if (list2.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)list2, Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = list2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    PsiClass it = (PsiClass)a;
                    boolean bl = false;
                    boolean bl2 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, !(it instanceof ClsClassImpl));
                }
            });
        }
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(psiPackage.getQualifiedName()), scope);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFile[0]);
    }

    @Override
    @NotNull
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope, "scope");
        return arg_0 -> JavaElementFinder.getPackageFilesFilter$lambda$2(psiPackage, arg_0);
    }

    private static final boolean getPackageFilesFilter$lambda$2(PsiPackage $psiPackage, PsiFile input) {
        Intrinsics.checkNotNullParameter($psiPackage, "$psiPackage");
        return !(input instanceof KtFile) ? true : Intrinsics.areEqual($psiPackage.getQualifiedName(), ((KtFile)input).getPackageFqName().asString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "()V", "byClasspathComparator", "Ljava/util/Comparator;", "Lksp/com/intellij/psi/PsiElement;", "Lkotlin/Comparator;", "searchScope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "getInstance", "Lksp/org/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lksp/com/intellij/openapi/project/Project;", "light-classes-base"})
    @SourceDebugExtension(value={"SMAP\nJavaElementFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,191:1\n25#2,2:192\n*S KotlinDebug\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion\n*L\n176#1:192,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            PsiElementFinder psiElementFinder;
            block2: {
                Intrinsics.checkNotNullParameter(project, "project");
                PsiElementFinder[] psiElementFinderArray = PsiElementFinder.EP.getPoint(project).getExtensions();
                Intrinsics.checkNotNullExpressionValue(psiElementFinderArray, "getExtensions(...)");
                PsiElementFinder[] $this$firstIsInstanceOrNull$iv = psiElementFinderArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (PsiElementFinder element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    psiElementFinder = element$iv;
                    break block2;
                }
                psiElementFinder = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)psiElementFinder;
            if (javaElementFinder == null) {
                throw new IllegalStateException((JavaElementFinder.class.getSimpleName() + " is not found for project " + project).toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter(searchScope, "searchScope");
            return (arg_0, arg_1) -> Companion.byClasspathComparator$lambda$0(searchScope, arg_0, arg_1);
        }

        private static final int byClasspathComparator$lambda$0(GlobalSearchScope $searchScope, PsiElement o1, PsiElement o2) {
            Intrinsics.checkNotNullParameter($searchScope, "$searchScope");
            VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
            VirtualFile f2 = PsiUtilCore.getVirtualFile(o2);
            return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : $searchScope.compare(f2, f1)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

