/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.project.structure.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.SmartPsiElementPointer;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModule;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\b\u00101\u001a\u000202H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0016\u00a8\u00063"}, d2={"Lksp/org/jetbrains/kotlin/analysis/project/structure/impl/KtDanglingFileModuleImpl;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtDanglingFileModule;", "file", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "contextModule", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "resolutionMode", "Lksp/org/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;)V", "analyzerServices", "Lksp/org/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getContextModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "directDependsOnDependencies", "", "getDirectDependsOnDependencies", "()Ljava/util/List;", "directFriendDependencies", "getDirectFriendDependencies", "directRegularDependencies", "getDirectRegularDependencies", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "fileRef", "Lksp/com/intellij/psi/SmartPsiElementPointer;", "isCodeFragment", "", "()Z", "platform", "Lksp/org/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "project", "Lksp/com/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolutionMode", "()Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "equals", "other", "", "hashCode", "", "project-structure"})
@SourceDebugExtension(value={"SMAP\nKtDanglingFileModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtDanglingFileModuleImpl.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtDanglingFileModuleImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class KtDanglingFileModuleImpl
implements KtDanglingFileModule {
    @NotNull
    private final KtModule contextModule;
    @NotNull
    private final DanglingFileResolutionMode resolutionMode;
    private final boolean isCodeFragment;
    @NotNull
    private final SmartPsiElementPointer<KtFile> fileRef;

    public KtDanglingFileModuleImpl(@NotNull KtFile file2, @NotNull KtModule contextModule, @NotNull DanglingFileResolutionMode resolutionMode) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(contextModule, "contextModule");
        Intrinsics.checkNotNullParameter((Object)resolutionMode, "resolutionMode");
        this.contextModule = contextModule;
        this.resolutionMode = resolutionMode;
        this.isCodeFragment = file2 instanceof KtCodeFragment;
        this.fileRef = PsiUtilsKt.createSmartPointer((PsiElement)file2);
        if (!(!Intrinsics.areEqual(this.getContextModule(), this))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.getContextModule() instanceof KtDanglingFileModule && !(file2 instanceof KtCodeFragment)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    @NotNull
    public KtModule getContextModule() {
        return this.contextModule;
    }

    @Override
    @NotNull
    public DanglingFileResolutionMode getResolutionMode() {
        return this.resolutionMode;
    }

    @Override
    public boolean isCodeFragment() {
        return this.isCodeFragment;
    }

    @Override
    @NotNull
    public KtFile getFile() {
        KtFile ktFile;
        KtFile ktFile2 = this.fileRef.getElement();
        if (ktFile2 != null) {
            KtFile ktFile3;
            KtFile it = ktFile3 = ktFile2;
            boolean bl = false;
            ktFile = it.isValid() ? ktFile3 : null;
        } else {
            ktFile = null;
        }
        if (ktFile == null) {
            throw new IllegalStateException("Dangling file module is invalid".toString());
        }
        return ktFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.getContextModule().getProject();
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.getContextModule().getPlatform();
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getContextModule().getAnalyzerServices();
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.getFile());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "fileScope(...)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return this.getContextModule().getDirectRegularDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectDependsOnDependencies() {
        return this.getContextModule().getDirectDependsOnDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getContextModule()), (Iterable)this.getContextModule().getDirectFriendDependencies());
    }

    @Override
    @NotNull
    public List<KtModule> getTransitiveDependsOnDependencies() {
        return this.getContextModule().getTransitiveDependsOnDependencies();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KtDanglingFileModuleImpl) {
            KtFile selfFile = this.fileRef.getElement();
            KtFile otherFile = ((KtDanglingFileModuleImpl)other).fileRef.getElement();
            return selfFile != null && Intrinsics.areEqual(selfFile, otherFile) && Intrinsics.areEqual(this.getContextModule(), ((KtDanglingFileModuleImpl)other).getContextModule()) && this.getResolutionMode() == ((KtDanglingFileModuleImpl)other).getResolutionMode();
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.fileRef.getElement(), this.getContextModule()};
        return Objects.hash(objectArray);
    }
}

