/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import ksp.org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassData;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedDataFinder;", "Lksp/org/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "classFinder", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "log", "Lksp/com/intellij/openapi/diagnostic/Logger;", "jvmMetadataVersion", "Lksp/org/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;)V", "getClassFinder", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "findClassData", "Lksp/org/jetbrains/kotlin/serialization/deserialization/ClassData;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "decompiler-to-file-stubs"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;
    @NotNull
    private final JvmMetadataVersion jvmMetadataVersion;

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log2, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter(classFinder, "classFinder");
        Intrinsics.checkNotNullParameter(log2, "log");
        Intrinsics.checkNotNullParameter(jvmMetadataVersion, "jvmMetadataVersion");
        this.classFinder = classFinder;
        this.log = log2;
        this.jvmMetadataVersion = jvmMetadataVersion;
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.classFinder, classId, this.jvmMetadataVersion);
        if (kotlinJvmBinaryClass2 == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass2;
        KotlinClassHeader classHeader = binaryClass.getClassHeader();
        String[] data2 = classHeader.getData();
        if (data2 == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        String[] strings2 = classHeader.getStrings();
        if (strings2 == null) {
            this.log.error("String table not found in class " + binaryClass.getClassId());
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(data2, strings2);
        JvmNameResolver nameResolver2 = pair.component1();
        ProtoBuf.Class classProto2 = pair.component2();
        return new ClassData(nameResolver2, classProto2, classHeader.getMetadataVersion(), new KotlinJvmBinarySourceElement(binaryClass, null, false, null, 14, null));
    }
}

