/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinderKt;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaClass;
import ksp.org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "packageDirectory", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "findKotlinClassOrContent", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "Lksp/org/jetbrains/kotlin/load/java/structure/JavaClass;", "jvmMetadataVersion", "Lksp/org/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "findMetadata", "findMetadataTopLevelClassesInPackage", "", "", "hasMetadataPackage", "", "fqName", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nDirectoryBasedClassFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryBasedClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter(packageDirectory, "packageDirectory");
        Intrinsics.checkNotNullParameter(directoryPackageFqName, "directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        Intrinsics.checkNotNullParameter(jvmMetadataVersion, "jvmMetadataVersion");
        ClassId classId = JavaElementsKt.getClassId(javaClass);
        Intrinsics.checkNotNull(classId);
        return this.findKotlinClassOrContent(classId, jvmMetadataVersion);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(jvmMetadataVersion, "jvmMetadataVersion");
        if (!Intrinsics.areEqual(classId.getPackageFqName(), this.directoryPackageFqName)) {
            return null;
        }
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "pathSegments(...)");
        String targetName = CollectionsKt.joinToString$default(list2, "$", null, ".class", 0, null, null, 58, null);
        VirtualFile virtualFile2 = this.packageDirectory.findChild(targetName);
        if (virtualFile2 != null && DirectoryBasedClassFinderKt.access$isKotlinWithCompatibleAbiVersion(virtualFile2, jvmMetadataVersion)) {
            KotlinClassFinder.Result.KotlinClass kotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = ClsKotlinBinaryClassCache.getKotlinBinaryClass$default(ClsKotlinBinaryClassCache.Companion.getInstance(), virtualFile2, null, 2, null);
            if (kotlinJvmBinaryClass2 != null) {
                KotlinJvmBinaryClass p0 = kotlinJvmBinaryClass2;
                boolean bl = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
            } else {
                kotlinClass = null;
            }
            return kotlinClass;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return null;
    }

    @Override
    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return false;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }
}

