/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.psi;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompilerKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import ksp.org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInMetadataStubBuilder;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "readFile", "Lkotlin/Function2;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "(Lkotlin/jvm/functions/Function2;)V", "createCallableSource", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "file", "Lksp/org/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "filename", "", "decompiler-to-psi"})
final class KotlinBuiltInMetadataStubBuilder
extends KotlinMetadataStubBuilder {
    public KotlinBuiltInMetadataStubBuilder(@NotNull Function2<? super VirtualFile, ? super byte[], ? extends KotlinMetadataStubBuilder.FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(readFile, "readFile");
        super(KotlinBuiltInDecompilerKt.access$getStubVersionForStubBuilderAndDecompiler(), KotlinBuiltInFileType.INSTANCE, 1.INSTANCE, readFile);
    }

    @Override
    @Nullable
    protected SourceElement createCallableSource(@NotNull KotlinMetadataStubBuilder.FileWithMetadata.Compatible file2, @NotNull String filename) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(filename, "filename");
        String withoutExtension = StringsKt.removeSuffix(filename, (CharSequence)".kotlin_builtins");
        String fileNameForFacade = Intrinsics.areEqual(withoutExtension, "kotlin") ? "library" : withoutExtension;
        FqName facadeFqName = PackagePartClassUtils.getPackagePartFqName(file2.getPackageFqName(), fileNameForFacade);
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.Companion.topLevel(facadeFqName));
        Intrinsics.checkNotNullExpressionValue(jvmClassName, "byClassId(...)");
        ProtoBuf.Package package_ = file2.getProto().getPackage();
        Intrinsics.checkNotNullExpressionValue(package_, "getPackage(...)");
        return new JvmPackagePartSource(jvmClassName, null, package_, file2.getNameResolver(), null, false, null, null, 240, null);
    }
}

