/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.lifetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.ModificationTracker;
import ksp.org.jetbrains.kotlin.analysis.api.KtAnalysisAllowanceManager;
import ksp.org.jetbrains.kotlin.analysis.api.KtAnalysisApiInternals;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtAllowProhibitedAnalyzeFromWriteAction;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeTokenFactory;
import ksp.org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactoryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeToken;", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "project", "Lksp/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "factory", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "getFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "modificationTracker", "Lksp/com/intellij/openapi/util/ModificationTracker;", "onCreatedTimeStamp", "", "getInaccessibilityReason", "", "getInvalidationReason", "isAccessible", "", "isValid", "Companion", "analysis-api"})
public final class KtReadActionConfinementLifetimeToken
extends KtLifetimeToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KtLifetimeTokenFactory factory;
    @NotNull
    private static final ThreadLocal<Boolean> allowOnEdt;
    @NotNull
    private static final ThreadLocal<Boolean> allowFromWriteAction;

    public KtReadActionConfinementLifetimeToken(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.modificationTracker = KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker(project);
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.factory = KtReadActionConfinementLifetimeTokenFactory.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation";
        }
        throw new IllegalStateException("Getting invalidation reason for valid validity token".toString());
    }

    @Override
    public boolean isAccessible() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !allowOnEdt.get().booleanValue()) {
            return false;
        }
        if (application.isWriteAccessAllowed() && !allowFromWriteAction.get().booleanValue()) {
            return false;
        }
        if (KtAnalysisAllowanceManager.INSTANCE.getResolveIsForbiddenInActionWithName().get() != null) {
            return false;
        }
        if (!application.isReadAccessAllowed()) {
            return false;
        }
        if (!KtReadActionConfinementLifetimeTokenFactory.INSTANCE.isInsideAnalysisContext$analysis_api()) {
            return false;
        }
        return Intrinsics.areEqual(KtReadActionConfinementLifetimeTokenFactory.INSTANCE.currentToken$analysis_api(), this);
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !allowOnEdt.get().booleanValue()) {
            return "Called in EDT thread";
        }
        if (application.isWriteAccessAllowed() && !allowFromWriteAction.get().booleanValue()) {
            return "Called from write action";
        }
        if (!application.isReadAccessAllowed()) {
            return "Called outside read action";
        }
        String string2 = KtAnalysisAllowanceManager.INSTANCE.getResolveIsForbiddenInActionWithName().get();
        if (string2 != null) {
            String actionName = string2;
            boolean bl = false;
            return "Resolve is forbidden in " + actionName;
        }
        if (!KtReadActionConfinementLifetimeTokenFactory.INSTANCE.isInsideAnalysisContext$analysis_api()) {
            return "Called outside analyse method";
        }
        if (!Intrinsics.areEqual(KtReadActionConfinementLifetimeTokenFactory.INSTANCE.currentToken$analysis_api(), this)) {
            return "Using KtLifetimeOwner from previous analysis";
        }
        throw new IllegalStateException("Getting inaccessibility reason for validity token when it is accessible".toString());
    }

    @Override
    @NotNull
    public KtLifetimeTokenFactory getFactory() {
        return this.factory;
    }

    private static final Boolean allowOnEdt$lambda$1() {
        return false;
    }

    private static final Boolean allowFromWriteAction$lambda$2() {
        return false;
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(KtReadActionConfinementLifetimeToken::allowOnEdt$lambda$1);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        allowOnEdt = threadLocal;
        ThreadLocal<Boolean> threadLocal2 = ThreadLocal.withInitial(KtReadActionConfinementLifetimeToken::allowFromWriteAction$lambda$2);
        Intrinsics.checkNotNullExpressionValue(threadLocal2, "withInitial(...)");
        allowFromWriteAction = threadLocal2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeToken$Companion;", "", "()V", "allowFromWriteAction", "Ljava/lang/ThreadLocal;", "", "getAllowFromWriteAction$annotations", "getAllowFromWriteAction", "()Ljava/lang/ThreadLocal;", "allowOnEdt", "getAllowOnEdt$annotations", "getAllowOnEdt", "analysis-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<Boolean> getAllowOnEdt() {
            return allowOnEdt;
        }

        @KtAnalysisApiInternals
        public static /* synthetic */ void getAllowOnEdt$annotations() {
        }

        @NotNull
        public final ThreadLocal<Boolean> getAllowFromWriteAction() {
            return allowFromWriteAction;
        }

        @KtAnalysisApiInternals
        @KtAllowProhibitedAnalyzeFromWriteAction
        public static /* synthetic */ void getAllowFromWriteAction$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

