/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.analysis.api.components.KtSamResolver;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KtFirSamResolver;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSamConstructorSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.PointerUtilsKt;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KtSamConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirBodyResolveTransformer;
import ksp.org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0010B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver;", "Lksp/org/jetbrains/kotlin/analysis/api/components/KtSamResolver;", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getSamConstructor", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol;", "ktClassLikeSymbol", "Lksp/org/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "LocalSamResolver", "analysis-api-fir"})
public final class KtFirSamResolver
extends KtSamResolver
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        Intrinsics.checkNotNullParameter(token, "token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtSamConstructorSymbol getSamConstructor(@NotNull KtClassLikeSymbol ktClassLikeSymbol) {
        KtFirSamConstructorSymbol ktFirSamConstructorSymbol;
        Intrinsics.checkNotNullParameter(ktClassLikeSymbol, "ktClassLikeSymbol");
        ClassId classId = ktClassLikeSymbol.getClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        FirClassLikeDeclaration firClassLikeDeclaration = PointerUtilsKt.getClassLikeSymbol(this.getAnalysisSession(), classId2);
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass owner = firRegularClass;
        LocalSamResolver resolver2 = new LocalSamResolver(this.getAnalysisSession(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
        FirSimpleFunction firSimpleFunction = resolver2.getSamConstructor(owner);
        if (firSimpleFunction != null) {
            FirSimpleFunction it = firSimpleFunction;
            boolean bl = false;
            ktFirSamConstructorSymbol = this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir().getFunctionLikeBuilder().buildSamConstructorSymbol(it.getSymbol());
        } else {
            ktFirSamConstructorSymbol = null;
        }
        return ktFirSamConstructorSymbol;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver;", "", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "firSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/fir/FirSession;)V", "bodyResolveComponents", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "stubBodyResolveTransformer", "ksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1;", "getSamConstructor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "analysis-api-fir"})
    private static final class LocalSamResolver {
        @NotNull
        private final FirSession firSession;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final stubBodyResolveTransformer.1 stubBodyResolveTransformer;
        @NotNull
        private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents bodyResolveComponents;

        public LocalSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull FirSession firSession) {
            Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
            Intrinsics.checkNotNullParameter(firSession, "firSession");
            this.firSession = firSession;
            this.scopeSession = analysisSession.getScopeSessionFor(this.firSession);
            FirSession firSession2 = this.firSession;
            FirResolvePhase firResolvePhase = FirResolvePhase.BODY_RESOLVE;
            ScopeSession scopeSession = this.scopeSession;
            this.stubBodyResolveTransformer = new FirBodyResolveTransformer(firSession2, firResolvePhase, scopeSession){};
            this.bodyResolveComponents = new FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents(this.firSession, this.scopeSession, this.stubBodyResolveTransformer, this.stubBodyResolveTransformer.getContext());
        }

        @Nullable
        public final FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firClass) {
            Intrinsics.checkNotNullParameter(firClass, "firClass");
            FirSimpleFunction firSimpleFunction = this.bodyResolveComponents.getSamResolver().getSamConstructor(firClass);
            if (firSimpleFunction == null) {
                return null;
            }
            FirSimpleFunction samConstructor = firSimpleFunction;
            if (!Intrinsics.areEqual(samConstructor.getOrigin(), FirDeclarationOrigin.SamConstructor.INSTANCE)) {
                return null;
            }
            return samConstructor;
        }
    }
}

