/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.annotations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtEnumEntryAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtKClassAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0014\u001a\u00020\b*\u00060\tj\u0002`\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\b*\u00060\tj\u0002`\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0002JP\u0010\u001d\u001a\u00020\b\"\u0004\b\u0000\u0010\u001e*\u00060\tj\u0002`\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u00162\u0006\u0010 \u001a\u00020\u00042!\u0010\u0003\u001a\u001d\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\b0!\u00a2\u0006\u0002\b\"H\u0082\b\u00a8\u0006#"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer;", "", "()V", "render", "", "value", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "renderAnnotationApplication", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo;", "renderAnnotationConstantValue", "application", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue;", "renderArrayConstantValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue;", "renderConstantAnnotationValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;", "renderConstantValue", "renderConstantValueList", "list", "", "renderEnumEntryConstantValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue;", "renderKClassAnnotationValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue;", "renderNamedConstantValueList", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue;", "renderWithSeparator", "E", "collection", "separator", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKtAnnotationValueRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n94#1:102\n95#1,5:105\n100#1:111\n94#1:112\n95#1,5:115\n100#1:121\n1862#2,2:103\n1864#2:110\n1862#2,2:113\n1864#2:120\n1862#2,3:122\n*S KotlinDebug\n*F\n+ 1 KtAnnotationValueRenderer.kt\norg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValueRenderer\n*L\n75#1:102\n75#1:105,5\n75#1:111\n81#1:112\n81#1:115,5\n81#1:121\n75#1:103,2\n75#1:110\n81#1:113,2\n81#1:120\n94#1:122,3\n*E\n"})
public final class KtAnnotationValueRenderer {
    @NotNull
    public static final KtAnnotationValueRenderer INSTANCE = new KtAnnotationValueRenderer();

    private KtAnnotationValueRenderer() {
    }

    @NotNull
    public final String render(@NotNull KtAnnotationValue value2) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter(value2, "value");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderConstantValue($this$render_u24lambda_u240, value2);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private final void renderConstantValue(StringBuilder $this$renderConstantValue, KtAnnotationValue value2) {
        KtAnnotationValue ktAnnotationValue = value2;
        if (ktAnnotationValue instanceof KtAnnotationApplicationValue) {
            this.renderAnnotationConstantValue($this$renderConstantValue, (KtAnnotationApplicationValue)value2);
        } else if (ktAnnotationValue instanceof KtArrayAnnotationValue) {
            this.renderArrayConstantValue($this$renderConstantValue, (KtArrayAnnotationValue)value2);
        } else if (ktAnnotationValue instanceof KtEnumEntryAnnotationValue) {
            this.renderEnumEntryConstantValue($this$renderConstantValue, (KtEnumEntryAnnotationValue)value2);
        } else if (ktAnnotationValue instanceof KtConstantAnnotationValue) {
            this.renderConstantAnnotationValue($this$renderConstantValue, (KtConstantAnnotationValue)value2);
        } else if (Intrinsics.areEqual(ktAnnotationValue, KtUnsupportedAnnotationValue.INSTANCE)) {
            $this$renderConstantValue.append("error(\"non-annotation value\")");
        } else if (ktAnnotationValue instanceof KtKClassAnnotationValue) {
            this.renderKClassAnnotationValue($this$renderConstantValue, (KtKClassAnnotationValue)value2);
        }
    }

    private final void renderKClassAnnotationValue(StringBuilder $this$renderKClassAnnotationValue, KtKClassAnnotationValue value2) {
        KtKClassAnnotationValue ktKClassAnnotationValue = value2;
        if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtErrorClassAnnotationValue) {
            $this$renderKClassAnnotationValue.append("UNRESOLVED_CLASS");
        } else if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtLocalKClassAnnotationValue) {
            Name name2 = ((KtKClassAnnotationValue.KtLocalKClassAnnotationValue)value2).getKtClass().getNameAsName();
            $this$renderKClassAnnotationValue.append(name2 != null ? RenderingUtilsKt.render(name2) : null);
        } else if (ktKClassAnnotationValue instanceof KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue) {
            $this$renderKClassAnnotationValue.append(RenderingUtilsKt.render(((KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue)value2).getClassId().asSingleFqName()));
        }
        $this$renderKClassAnnotationValue.append("::class");
    }

    private final void renderConstantAnnotationValue(StringBuilder $this$renderConstantAnnotationValue, KtConstantAnnotationValue value2) {
        $this$renderConstantAnnotationValue.append(value2.getConstantValue().renderAsKotlinConstant());
    }

    private final void renderEnumEntryConstantValue(StringBuilder $this$renderEnumEntryConstantValue, KtEnumEntryAnnotationValue value2) {
        Object object = value2.getCallableId();
        $this$renderEnumEntryConstantValue.append(object != null && (object = ((CallableId)object).asSingleFqName()) != null ? ((FqName)object).asString() : null);
    }

    private final void renderAnnotationConstantValue(StringBuilder $this$renderAnnotationConstantValue, KtAnnotationApplicationValue application) {
        this.renderAnnotationApplication($this$renderAnnotationConstantValue, application.getAnnotationValue());
    }

    private final void renderAnnotationApplication(StringBuilder $this$renderAnnotationApplication, KtAnnotationApplicationWithArgumentsInfo value2) {
        $this$renderAnnotationApplication.append(value2.getClassId());
        if (!((Collection)value2.getArguments()).isEmpty()) {
            $this$renderAnnotationApplication.append("(");
            this.renderNamedConstantValueList($this$renderAnnotationApplication, (Collection<KtNamedAnnotationValue>)value2.getArguments());
            $this$renderAnnotationApplication.append(")");
        }
    }

    private final void renderArrayConstantValue(StringBuilder $this$renderArrayConstantValue, KtArrayAnnotationValue value2) {
        $this$renderArrayConstantValue.append("[");
        this.renderConstantValueList($this$renderArrayConstantValue, value2.getValues());
        $this$renderArrayConstantValue.append("]");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderConstantValueList(StringBuilder $this$renderConstantValueList, Collection<? extends KtAnnotationValue> list2) {
        KtAnnotationValueRenderer ktAnnotationValueRenderer = this;
        StringBuilder stringBuilder2 = $this$renderConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void constantValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KtAnnotationValue ktAnnotationValue = (KtAnnotationValue)element$iv;
            void $this$renderConstantValueList_u24lambda_u241 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            INSTANCE.renderConstantValue((StringBuilder)$this$renderConstantValueList_u24lambda_u241, (KtAnnotationValue)constantValue);
            if (index$iv == list2.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNamedConstantValueList(StringBuilder $this$renderNamedConstantValueList, Collection<KtNamedAnnotationValue> list2) {
        KtAnnotationValueRenderer ktAnnotationValueRenderer = this;
        StringBuilder stringBuilder2 = $this$renderNamedConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void namedValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KtNamedAnnotationValue ktNamedAnnotationValue = (KtNamedAnnotationValue)element$iv;
            void $this$renderNamedConstantValueList_u24lambda_u242 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            $this$renderNamedConstantValueList_u24lambda_u242.append(namedValue.getName());
            $this$renderNamedConstantValueList_u24lambda_u242.append(" = ");
            INSTANCE.renderConstantValue((StringBuilder)$this$renderNamedConstantValueList_u24lambda_u242, namedValue.getExpression());
            $this$renderNamedConstantValueList_u24lambda_u242.append(", ");
            if (index$iv == list2.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void renderWithSeparator(StringBuilder $this$renderWithSeparator, Collection<? extends E> collection, String separator, Function2<? super StringBuilder, ? super E, Unit> render2) {
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index2 = n;
            boolean bl = false;
            render2.invoke($this$renderWithSeparator, element2);
            if (index2 == collection.size() - 1) continue;
            $this$renderWithSeparator.append(separator);
        }
    }
}

