/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.xmlb;

import java.awt.Rectangle;
import java.util.List;
import ksp.com.intellij.openapi.util.text.StringUtilRt;
import ksp.com.intellij.serialization.MutableAccessor;
import ksp.com.intellij.util.XmlElement;
import ksp.com.intellij.util.xmlb.BeanBinding;
import ksp.com.intellij.util.xmlb.Binding;
import ksp.com.intellij.util.xmlb.MapBinding;
import ksp.com.intellij.util.xmlb.MultiNodeBinding;
import ksp.com.intellij.util.xmlb.NestedBinding;
import ksp.com.intellij.util.xmlb.SerializationFilter;
import ksp.com.intellij.util.xmlb.annotations.Property;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding binding;
    private final MutableAccessor accessor;
    final boolean isFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean isFlat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        this.accessor = accessor;
        this.binding = binding;
        this.isFlat = isFlat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.accessor;
        if (mutableAccessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(2);
        }
        return mutableAccessor;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context2, @Nullable SerializationFilter filter2) {
        Object value2;
        if (o == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(3);
        }
        if ((value2 = this.accessor.read(o)) == null) {
            return null;
        }
        if (this.isFlat) {
            Element element2 = (Element)context2;
            if (this.beanStyle == Property.Style.ATTRIBUTE && value2 instanceof Rectangle) {
                Rectangle bounds2 = (Rectangle)value2;
                LOG.assertTrue(element2 != null);
                element2.setAttribute("x", Integer.toString(bounds2.x));
                element2.setAttribute("y", Integer.toString(bounds2.y));
                element2.setAttribute("width", Integer.toString(bounds2.width));
                element2.setAttribute("height", Integer.toString(bounds2.height));
            } else {
                ((BeanBinding)this.binding).serializeInto(value2, element2, filter2);
            }
            return null;
        }
        return this.binding.serialize(value2, context2, filter2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserializeUnsafe(Object context2, @NotNull Element element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(4);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element2);
            return context2;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).myBeanClass == Rectangle.class) {
                String xA = element2.getAttributeValue("x");
                String yA = element2.getAttributeValue("y");
                String wA = element2.getAttributeValue("width");
                String hA = element2.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context2;
                int x = StringUtilRt.parseInt(xA, 0);
                int y = StringUtilRt.parseInt(yA, 0);
                int h = StringUtilRt.parseInt(hA, 0);
                int w = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.binding.deserializeUnsafe(currentValue, element2);
            }
            if (currentValue == deserializedValue) return context2;
            this.accessor.set(context2, deserializedValue);
        }
        return context2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserializeUnsafe(Object context2, @NotNull XmlElement element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(5);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element2);
            return context2;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).myBeanClass == Rectangle.class) {
                String xA = element2.getAttributeValue("x");
                String yA = element2.getAttributeValue("y");
                String wA = element2.getAttributeValue("width");
                String hA = element2.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context2;
                int x = StringUtilRt.parseInt(xA, 0);
                int y = StringUtilRt.parseInt(yA, 0);
                int h = StringUtilRt.parseInt(hA, 0);
                int w = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.binding.deserializeUnsafe(currentValue, element2);
            }
            if (currentValue == deserializedValue) return context2;
            this.accessor.set(context2, deserializedValue);
        }
        return context2;
    }

    @Override
    @NotNull
    public Object deserializeList(@NotNull Object context2, @NotNull List<Element> elements) {
        if (context2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(7);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.binding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.accessor.set(context2, deserializedValue);
            }
        }
        Object object = context2;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Override
    @NotNull
    public Object deserializeList2(@NotNull Object context2, @NotNull List<XmlElement> elements) {
        if (context2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(10);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList2(this.binding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.accessor.set(context2, deserializedValue);
            }
        }
        Object object = context2;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Override
    public boolean isMulti() {
        return this.binding instanceof MultiNodeBinding && ((MultiNodeBinding)this.binding).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(12);
        }
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(element2.getName());
        }
        return this.binding.isBoundTo(element2);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(13);
        }
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(element2.name);
        }
        return this.binding.isBoundTo(element2);
    }

    public String toString() {
        return this.binding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList2";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

