/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortMaps;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator {
    public static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    @NotNull
    private final Path myFile;
    @NotNull
    private final Object2ShortMap<String> myState;

    public SimpleStringPersistentEnumerator(@NotNull Path file2) {
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
        this.myState = SimpleStringPersistentEnumerator.readStorageFromDisk(file2);
    }

    public synchronized short enumerate(@Nullable String value2) {
        if (this.myState.containsKey(value2)) {
            return this.myState.getShort(value2);
        }
        int n = this.myState.size() + 1;
        assert (n <= Short.MAX_VALUE) : "Number of indices exceeded: " + n;
        this.myState.put(value2, (short)n);
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myState, this.myFile);
        return (short)n;
    }

    @NotNull
    public synchronized Collection<String> entries() {
        return new ArrayList<String>(this.myState.keySet());
    }

    @Nullable
    public synchronized String valueOf(short idx) {
        for (Object2ShortMap.Entry entry : this.myState.object2ShortEntrySet()) {
            if (entry.getShortValue() != idx) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public synchronized void forceDiskSync() {
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myState, this.myFile);
    }

    public synchronized boolean isEmpty() {
        return this.myState.isEmpty();
    }

    @NotNull
    public String dumpToString() {
        String string2 = this.myState.object2ShortEntrySet().stream().sorted(Comparator.comparing(e -> e.getShortValue())).map(e -> (String)e.getKey() + "->" + e.getShortValue()).collect(Collectors.joining("\n"));
        if (string2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    private static Object2ShortMap<String> readStorageFromDisk(@NotNull Path file2) {
        Object2ShortOpenHashMap<String> object2ShortOpenHashMap;
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(2);
        }
        try {
            Object2ShortOpenHashMap<String> nameToIdRegistry = new Object2ShortOpenHashMap<String>();
            List<String> lines = Files.readAllLines(file2, Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                String name2 = lines.get(i);
                nameToIdRegistry.put(name2, (short)(i + 1));
            }
            object2ShortOpenHashMap = nameToIdRegistry;
        }
        catch (IOException e) {
            SimpleStringPersistentEnumerator.writeStorageToDisk(Object2ShortMaps.emptyMap(), file2);
            return new Object2ShortOpenHashMap<String>();
        }
        if (object2ShortOpenHashMap == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(3);
        }
        return object2ShortOpenHashMap;
    }

    private static void writeStorageToDisk(@NotNull Object2ShortMap<String> state, @NotNull Path file2) {
        if (state == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(5);
        }
        try {
            String[] names2 = new String[state.size()];
            ObjectIterator<Object2ShortMap.Entry<String>> iterator2 = Object2ShortMaps.fastIterator(state);
            while (iterator2.hasNext()) {
                Object2ShortMap.Entry entry = (Object2ShortMap.Entry)iterator2.next();
                names2[entry.getShortValue() - 1] = (String)entry.getKey();
            }
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.write(file2, Arrays.asList(names2), Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpToString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readStorageFromDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readStorageFromDisk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeStorageToDisk";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

