/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.util.CompressionUtil;
import ksp.com.intellij.util.io.DataExternalizer;
import ksp.com.intellij.util.io.DataInputOutputUtil;
import ksp.com.intellij.util.io.EndOfLog;
import ksp.com.intellij.util.io.KeyDescriptor;
import ksp.com.intellij.util.io.PersistentMapWalPlayer$WhenMappings;
import ksp.com.intellij.util.io.VersionUpdatedException;
import ksp.com.intellij.util.io.WalEvent;
import ksp.com.intellij.util.io.WalRecord;
import ksp.com.intellij.util.io.WriteAheadLogKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0016\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u001fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lksp/com/intellij/util/io/PersistentMapWalPlayer;", "K", "V", "Ljava/io/Closeable;", "keyDescriptor", "Lksp/com/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lksp/com/intellij/util/io/DataExternalizer;", "file", "Ljava/nio/file/Path;", "(Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Ljava/nio/file/Path;)V", "input", "Ljava/io/DataInputStream;", "useCompression", "", "getUseCompression$intellij_platform_util", "()Z", "version", "", "getVersion", "()I", "close", "", "ensureCompatible", "expectedVersion", "readByteArray", "", "inputStream", "readNextEvent", "Lksp/com/intellij/util/io/WalEvent;", "readWal", "Lkotlin/sequences/Sequence;", "intellij.platform.util"})
public final class PersistentMapWalPlayer<K, V>
implements Closeable {
    private final DataInputStream input;
    private final boolean useCompression;
    private final int version;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    public final boolean getUseCompression$intellij_platform_util() {
        return this.useCompression;
    }

    public final int getVersion() {
        return this.version;
    }

    private final void ensureCompatible(int expectedVersion, DataInputStream input, Path file2) throws IOException {
        int actualVersion = DataInputOutputUtil.readINT(input);
        if (actualVersion != expectedVersion) {
            throw (Throwable)new VersionUpdatedException(file2, expectedVersion, actualVersion);
        }
    }

    @NotNull
    public final Sequence<WalEvent<K, V>> readWal() {
        return SequencesKt.generateSequence(new Function0<WalEvent<K, V>>(this){
            final /* synthetic */ PersistentMapWalPlayer this$0;

            @Nullable
            public final WalEvent<K, V> invoke() {
                return PersistentMapWalPlayer.access$readNextEvent(this.this$0);
            }
            {
                this.this$0 = persistentMapWalPlayer;
                super(0);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private final WalEvent<K, V> readNextEvent() throws IOException {
        WalEvent walEvent;
        WalRecord record2 = null;
        try {
            record2 = WalRecord.Companion.read(this.input);
        }
        catch (EndOfLog e) {
            return null;
        }
        catch (IOException e) {
            WalEvent.CorruptionEvent corruptionEvent = WalEvent.CorruptionEvent.INSTANCE;
            if (corruptionEvent == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.io.WalEvent<K, V>");
            }
            return corruptionEvent;
        }
        if (WriteAheadLogKt.getDebugWalRecords()) {
            String e = "read: " + record2;
            boolean bl = false;
            System.out.println((Object)e);
        }
        DataInputStream dataInputStream = record2.getPayload().toInputStream();
        Intrinsics.checkNotNullExpressionValue(dataInputStream, "record.payload.toInputStream()");
        DataInputStream recordStream = dataInputStream;
        switch (PersistentMapWalPlayer$WhenMappings.$EnumSwitchMapping$0[record2.getOpCode().ordinal()]) {
            case 1: {
                walEvent = new WalEvent.PutEvent(this.keyDescriptor.read(recordStream), WriteAheadLogKt.access$readData(this.readByteArray(recordStream), this.valueExternalizer));
                break;
            }
            case 2: {
                walEvent = new WalEvent.RemoveEvent(this.keyDescriptor.read(recordStream));
                break;
            }
            case 3: {
                walEvent = new WalEvent.AppendEvent(this.keyDescriptor.read(recordStream), this.readByteArray(recordStream));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return walEvent;
    }

    private final byte[] readByteArray(DataInputStream inputStream) {
        if (this.useCompression) {
            byte[] byArray = CompressionUtil.readCompressed(inputStream);
            Intrinsics.checkNotNullExpressionValue(byArray, "CompressionUtil.readCompressed(inputStream)");
            return byArray;
        }
        byte[] byArray = new byte[inputStream.readInt()];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        inputStream.readFully(it);
        return byArray;
    }

    public PersistentMapWalPlayer(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, @NotNull Path file2) throws IOException {
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(file2, "file");
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        if (!Files.exists(file2, new LinkOption[0])) {
            throw (Throwable)new FileNotFoundException(((Object)file2).toString());
        }
        InputStream inputStream = Files.newInputStream(file2, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream, "Files.newInputStream(file)");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        boolean bl = false;
        this.input = new DataInputStream(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
        this.ensureCompatible(this.version, this.input, file2);
        this.useCompression = this.input.readBoolean();
    }

    public static final /* synthetic */ WalEvent access$readNextEvent(PersistentMapWalPlayer $this) {
        return $this.readNextEvent();
    }
}

