/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.containers.SLRUMap;
import ksp.com.intellij.util.containers.ShareableKey;
import ksp.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class PersistentEnumeratorCache {
    private static final int ENUMERATION_CACHE_SIZE = SystemProperties.getIntProperty("idea.enumerationCacheSize", 8192);
    private static final CacheKey ourFlyweight = new FlyweightKey();
    private static final SLRUMap<Object, Integer> ourEnumerationCache = new SLRUMap(ENUMERATION_CACHE_SIZE, ENUMERATION_CACHE_SIZE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheId(Object value2, int id, PersistentEnumeratorBase<?> owner) {
        SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
        synchronized (sLRUMap) {
            ourEnumerationCache.put(new CacheKey(value2, owner), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getCachedId(Object value2, PersistentEnumeratorBase<?> owner) {
        SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
        synchronized (sLRUMap) {
            Integer cachedId = ourEnumerationCache.get(PersistentEnumeratorCache.sharedKey(value2, owner));
            if (cachedId != null) {
                return cachedId;
            }
        }
        return 0;
    }

    private static CacheKey sharedKey(Object key, PersistentEnumeratorBase<?> owner) {
        PersistentEnumeratorCache.ourFlyweight.key = key;
        PersistentEnumeratorCache.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    @TestOnly
    public static void clearCacheForTests() {
        ourEnumerationCache.clear();
    }

    private static class FlyweightKey
    extends CacheKey {
        FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumeratorBase<?> owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumeratorBase<?> owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

